/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.secure;

import java.math.BigInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OCRA {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    private OCRA() {
    }

    private static byte[] hmac_sha1(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String addLeadingZeros(String s, int i) {
        StringBuilder builder = new StringBuilder(s);
        while (builder.length() < i) {
            builder.insert(0, "0");
        }
        return builder.toString();
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, ret, 0, ret.length);
        return ret;
    }

    public static String generateOCRA(String sharedSecret, String challenge, String sessionKey) {
        return OCRA.generateOCRA("OCRA-1:HOTP-SHA1-6:QH10-S064", sharedSecret, null, challenge, null, sessionKey, null);
    }

    public static String generateOCRA(String ocraSuite, String key, String counter, String question, String password, String sessionInformation, String timeStamp) {
        String crypto = "";
        int ocraSuiteLength = ocraSuite.getBytes().length;
        int counterLength = 0;
        int questionLength = 0;
        int passwordLength = 0;
        int sessionInformationLength = 0;
        int timeStampLength = 0;
        String[] splitOcraSuite = ocraSuite.split(":");
        String cryptoFunction = splitOcraSuite[1];
        String dataInput = splitOcraSuite[2];
        if (cryptoFunction.toLowerCase().indexOf("sha1") > 1) {
            crypto = "HmacSHA1";
        }
        if (cryptoFunction.toLowerCase().indexOf("sha256") > 1) {
            crypto = "HmacSHA256";
        }
        if (cryptoFunction.toLowerCase().indexOf("sha512") > 1) {
            crypto = "HmacSHA512";
        }
        int codeDigits = Integer.decode(cryptoFunction.substring(cryptoFunction.lastIndexOf("-") + 1));
        String dataInputLower = dataInput.toLowerCase();
        if (dataInputLower.startsWith("c")) {
            counter = OCRA.addLeadingZeros(counter, 16);
            counterLength = 8;
        }
        if (dataInputLower.startsWith("q") || dataInputLower.contains("-q")) {
            StringBuilder questionBuilder = new StringBuilder(question);
            while (questionBuilder.length() < 256) {
                questionBuilder.append("0");
            }
            question = questionBuilder.toString();
            questionLength = 128;
        }
        if (dataInputLower.indexOf("psha1") > 1) {
            password = OCRA.addLeadingZeros(password, 40);
            passwordLength = 20;
        }
        if (dataInputLower.indexOf("psha256") > 1) {
            password = OCRA.addLeadingZeros(password, 64);
            passwordLength = 32;
        }
        if (dataInputLower.indexOf("psha512") > 1) {
            password = OCRA.addLeadingZeros(password, 128);
            passwordLength = 64;
        }
        if (dataInputLower.indexOf("s064") > 1) {
            sessionInformation = OCRA.addLeadingZeros(sessionInformation, 128);
            sessionInformationLength = 64;
        }
        if (dataInputLower.indexOf("s128") > 1) {
            sessionInformation = OCRA.addLeadingZeros(sessionInformation, 256);
            sessionInformationLength = 128;
        }
        if (dataInputLower.indexOf("s256") > 1) {
            sessionInformation = OCRA.addLeadingZeros(sessionInformation, 512);
            sessionInformationLength = 256;
        }
        if (dataInputLower.indexOf("s512") > 1) {
            sessionInformation = OCRA.addLeadingZeros(sessionInformation, 1024);
            sessionInformationLength = 512;
        }
        if (dataInputLower.startsWith("t") || dataInputLower.indexOf("-t") > 1) {
            timeStamp = OCRA.addLeadingZeros(timeStamp, 16);
            timeStampLength = 8;
        }
        byte[] msg = new byte[ocraSuiteLength + counterLength + questionLength + passwordLength + sessionInformationLength + timeStampLength + 1];
        byte[] bArray = ocraSuite.getBytes();
        System.arraycopy(bArray, 0, msg, 0, bArray.length);
        msg[bArray.length] = 0;
        if (counterLength > 0) {
            bArray = OCRA.hexStr2Bytes(counter);
            System.arraycopy(bArray, 0, msg, ocraSuiteLength + 1, bArray.length);
        }
        if (questionLength > 0) {
            bArray = OCRA.hexStr2Bytes(question);
            System.arraycopy(bArray, 0, msg, ocraSuiteLength + 1 + counterLength, bArray.length);
        }
        if (passwordLength > 0) {
            bArray = OCRA.hexStr2Bytes(password);
            System.arraycopy(bArray, 0, msg, ocraSuiteLength + 1 + counterLength + questionLength, bArray.length);
        }
        if (sessionInformationLength > 0) {
            bArray = OCRA.hexStr2Bytes(sessionInformation);
            System.arraycopy(bArray, 0, msg, ocraSuiteLength + 1 + counterLength + questionLength + passwordLength, bArray.length);
        }
        if (timeStampLength > 0) {
            bArray = OCRA.hexStr2Bytes(timeStamp);
            System.arraycopy(bArray, 0, msg, ocraSuiteLength + 1 + counterLength + questionLength + passwordLength + sessionInformationLength, bArray.length);
        }
        bArray = OCRA.hexStr2Bytes(key);
        byte[] hash = OCRA.hmac_sha1(crypto, bArray, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[codeDigits];
        return OCRA.addLeadingZeros(Integer.toString(otp), codeDigits);
    }
}

