/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.model;

import java.io.Serializable;
import java.time.Instant;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import tiqr.org.model.AuthenticationStatus;

@Document(collection="authentications")
public class Authentication
implements Serializable {
    @Id
    private String id;
    private String userID;
    private String userDisplayName;
    private String sessionKey;
    private String challenge;
    private AuthenticationStatus status;
    private Instant created;
    private Instant updated;

    public Authentication(String userID, String userDisplayName, String sessionKey, String challenge, AuthenticationStatus status) {
        this.userID = userID;
        this.userDisplayName = userDisplayName;
        this.sessionKey = sessionKey;
        this.challenge = challenge;
        this.status = status;
        this.created = Instant.now();
        this.updated = Instant.now();
    }

    public void update(AuthenticationStatus newStatus) {
        this.status = newStatus;
        this.updated = Instant.now();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUserID() {
        return this.userID;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Generated
    public String getChallenge() {
        return this.challenge;
    }

    @Generated
    public AuthenticationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Generated
    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    @Generated
    public void setStatus(AuthenticationStatus status) {
        this.status = status;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(Instant updated) {
        this.updated = updated;
    }

    @Generated
    public Authentication() {
    }
}

