/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.push;

import tiqr.org.model.NotificationType;
import tiqr.org.model.Registration;
import tiqr.org.push.APNS;
import tiqr.org.push.APNSConfiguration;
import tiqr.org.push.GCM;
import tiqr.org.push.GCMConfiguration;
import tiqr.org.push.PushNotificationException;
import tiqr.org.push.PushNotifier;

public class NotificationGateway
implements PushNotifier {
    private final APNS apns;
    private final GCM gcm;

    public NotificationGateway(APNSConfiguration apnsConfiguration, GCMConfiguration gcmConfiguration) {
        this.apns = new APNS(apnsConfiguration);
        this.gcm = new GCM(gcmConfiguration);
    }

    @Override
    public String push(Registration registration, String authorizationUrl) throws PushNotificationException {
        registration.validateForPushNotification();
        return registration.getNotificationType().equals(NotificationType.APNS.name()) ? this.apns.push(registration, authorizationUrl) : this.gcm.push(registration, authorizationUrl);
    }
}

