/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.secure;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import tiqr.org.secure.OCRA;

public class Challenge {
    private static final SecureRandom secureRandom;

    private Challenge() {
    }

    public static String generateQH10Challenge() {
        return secureRandom.ints(10L, 0, 16).boxed().map(Integer::toHexString).collect(Collectors.joining());
    }

    public static String generateNonce() {
        return Challenge.generateRandom(64);
    }

    public static String generateSessionKey() {
        return Challenge.generateRandom(32);
    }

    private static String generateRandom(int length) {
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return Hex.encodeHexString((byte[])bytes);
    }

    public static void verifyOcra(String secret, String challenge, String sessionKey, String expectedOcra) {
        String ocra = OCRA.generateOCRA(secret, challenge, sessionKey);
        boolean equals = MessageDigest.isEqual(ocra.getBytes(StandardCharsets.UTF_8), expectedOcra.getBytes(StandardCharsets.UTF_8));
        if (!equals) {
            throw new IllegalArgumentException(String.format("Response does not match. Expected %s, but got %s", ocra, expectedOcra));
        }
    }

    static {
        try {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

