/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.time.Instant;
import org.springframework.util.StringUtils;
import tiqr.org.TiqrService;
import tiqr.org.model.Authentication;
import tiqr.org.model.AuthenticationData;
import tiqr.org.model.AuthenticationStatus;
import tiqr.org.model.Enrollment;
import tiqr.org.model.EnrollmentStatus;
import tiqr.org.model.Identity;
import tiqr.org.model.MetaData;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;
import tiqr.org.model.Service;
import tiqr.org.push.APNSConfiguration;
import tiqr.org.push.GCMConfiguration;
import tiqr.org.push.NotificationGateway;
import tiqr.org.repo.AuthenticationRepository;
import tiqr.org.repo.EnrollmentRepository;
import tiqr.org.repo.RegistrationRepository;
import tiqr.org.secure.Challenge;
import tiqr.org.secure.SecretCipher;

public class DefaultTiqrService
implements TiqrService {
    private final EnrollmentRepository enrollmentRepository;
    private final RegistrationRepository registrationRepository;
    private final AuthenticationRepository authenticationRepository;
    private final Service service;
    private final SecretCipher secretCipher;
    private final NotificationGateway notificationGateway;

    public DefaultTiqrService(EnrollmentRepository enrollmentRepository, RegistrationRepository registrationRepository, AuthenticationRepository authenticationRepository, Service service, String secret, APNSConfiguration apnsConfiguration, GCMConfiguration gcmConfiguration) {
        this.enrollmentRepository = enrollmentRepository;
        this.registrationRepository = registrationRepository;
        this.authenticationRepository = authenticationRepository;
        this.service = service;
        this.secretCipher = new SecretCipher(secret);
        this.notificationGateway = new NotificationGateway(apnsConfiguration, gcmConfiguration);
    }

    @Override
    public Enrollment startEnrollment(String userID, String userDisplayName) {
        this.enrollmentRepository.deleteByUserID(userID);
        this.registrationRepository.deleteByUserId(userID);
        Enrollment enrollment = new Enrollment(Challenge.generateNonce(), userID, userDisplayName, EnrollmentStatus.INITIALIZED);
        return this.enrollmentRepository.save(enrollment);
    }

    @Override
    public MetaData getMetaData(String enrollmentKey) {
        Enrollment enrollment = this.enrollmentRepository.findEnrollmentByKey(enrollmentKey).orElseThrow(IllegalArgumentException::new);
        if (!enrollment.getStatus().equals((Object)EnrollmentStatus.INITIALIZED)) {
            throw new IllegalArgumentException("Metadata can only be retrieved when the status is INITIALIZED. Current status is " + enrollment.getStatus());
        }
        String enrollmentSecret = Challenge.generateNonce();
        enrollment.setEnrollmentSecret(enrollmentSecret);
        enrollment.update(EnrollmentStatus.RETRIEVED);
        this.enrollmentRepository.save(enrollment);
        return new MetaData(Service.addEnrollmentSecret(this.service, enrollmentSecret), new Identity(enrollment));
    }

    @Override
    public Registration enrollData(Registration registration) {
        Enrollment enrollment = this.enrollmentRepository.findEnrollmentByEnrollmentSecret(registration.getEnrollmentSecret()).orElseThrow(IllegalArgumentException::new);
        if (!enrollment.getStatus().equals((Object)EnrollmentStatus.RETRIEVED)) {
            throw new IllegalArgumentException("Enrollment can only be called when the status is RETRIEVED. Current status is " + enrollment.getStatus());
        }
        registration.setUserId(enrollment.getUserID());
        registration.setUserDisplayName(enrollment.getUserDisplayName());
        registration.setStatus(RegistrationStatus.INITIALIZED);
        registration.validateForInitialEnrollment();
        registration.setSecret(this.secretCipher.encrypt(registration.getSecret()));
        Instant now = Instant.now();
        registration.setCreated(now);
        registration.setUpdated(now);
        Registration savedRegistration = this.registrationRepository.save(registration);
        enrollment.update(EnrollmentStatus.PROCESSED);
        this.enrollmentRepository.save(enrollment);
        return savedRegistration;
    }

    @Override
    public Registration finishRegistration(String userId) {
        Registration registration = this.registrationRepository.findRegistrationByUserId(userId).orElseThrow(IllegalArgumentException::new);
        registration.setStatus(RegistrationStatus.FINALIZED);
        return this.registrationRepository.save(registration);
    }

    @Override
    public Enrollment enrollmentStatus(String enrollmentKey) {
        return this.enrollmentRepository.findEnrollmentByKey(enrollmentKey).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public Authentication startAuthentication(String userId, String userDisplayName, String eduIdAppBaseUrl, boolean sendPushNotification) {
        Registration registration = this.registrationRepository.findRegistrationByUserId(userId).orElseThrow(IllegalArgumentException::new);
        if (!RegistrationStatus.FINALIZED.equals((Object)registration.getStatus())) {
            throw new IllegalArgumentException("Registration is not FINALIZED, but " + registration.getStatus());
        }
        String sessionKey = Challenge.generateSessionKey();
        String challenge = Challenge.generateQH10Challenge();
        String authenticationUrl = String.format("%s/tiqrauth?u=%s&s=%s&q=%s&i=%s&v=%s", eduIdAppBaseUrl, this.encode(userId), this.encode(sessionKey), this.encode(challenge), this.encode(this.service.getIdentifier()), this.encode(this.service.getVersion()));
        Authentication authentication = new Authentication(userId, userDisplayName, sessionKey, challenge, authenticationUrl, AuthenticationStatus.PENDING);
        Authentication savedAuthentication = this.authenticationRepository.save(authentication);
        if (sendPushNotification) {
            this.notificationGateway.push(registration, authenticationUrl);
        }
        return savedAuthentication;
    }

    @Override
    public void postAuthentication(AuthenticationData authenticationData) {
        Authentication authentication = this.authenticationRepository.findAuthenticationBySessionKey(authenticationData.getSessionKey()).orElseThrow(IllegalArgumentException::new);
        if (!authentication.getStatus().equals((Object)AuthenticationStatus.PENDING)) {
            throw new IllegalArgumentException("Authentication can only be called when the status is PENDING. Current status is " + authentication.getStatus());
        }
        Registration registration = this.registrationRepository.findRegistrationByUserId(authentication.getUserID()).orElseThrow(IllegalArgumentException::new);
        String decryptedSecret = this.secretCipher.decrypt(registration.getSecret());
        Challenge.verifyOcra(decryptedSecret, authentication.getChallenge(), authentication.getSessionKey(), authenticationData.getResponse());
        String notificationAddress = authenticationData.getNotificationAddress();
        if (StringUtils.hasText((String)notificationAddress)) {
            registration.setNotificationAddress(notificationAddress);
        }
        registration.setUpdated(Instant.now());
        this.registrationRepository.save(registration);
        authentication.update(AuthenticationStatus.SUCCESS);
        this.authenticationRepository.save(authentication);
    }

    @Override
    public Authentication authenticationStatus(String sessionKey) {
        return this.authenticationRepository.findAuthenticationBySessionKey(sessionKey).orElseThrow(IllegalArgumentException::new);
    }

    private String encode(String s) {
        return URLEncoder.encode(s, Charset.defaultCharset());
    }
}

