/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.push;

import tiqr.org.model.NotificationType;
import tiqr.org.model.Registration;
import tiqr.org.push.APNS;
import tiqr.org.push.APNSConfiguration;
import tiqr.org.push.GCM;
import tiqr.org.push.GCMConfiguration;
import tiqr.org.push.PushNotificationException;
import tiqr.org.push.PushNotifier;

public class NotificationGateway
implements PushNotifier {
    private final APNS apns;
    private final GCM gcm;

    public NotificationGateway(APNSConfiguration apnsConfiguration, GCMConfiguration gcmConfiguration) {
        this.apns = new APNS(apnsConfiguration);
        this.gcm = new GCM(gcmConfiguration);
    }

    @Override
    public String push(Registration registration, String authorizationUrl) throws PushNotificationException {
        registration.validateForPushNotification();
        switch (NotificationType.valueOf(registration.getNotificationType())) {
            case FCM: 
            case GCM: 
            case FCM_DIRECT: {
                return this.gcm.push(registration, authorizationUrl);
            }
            case APNS: 
            case APNS_DIRECT: {
                return this.apns.push(registration, authorizationUrl);
            }
        }
        throw new IllegalArgumentException("Unknown NotificationType" + registration.getNotificationType());
    }
}

