/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecretCipher {
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private final SecretKeySpec secretKey;
    private final GCMParameterSpec parameterSpec;

    public SecretCipher(String secret) {
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        byte[] digest = sha.digest(secret.getBytes(StandardCharsets.UTF_8));
        this.secretKey = new SecretKeySpec(Arrays.copyOf(digest, 32), "AES");
        this.parameterSpec = new GCMParameterSpec(128, secret.getBytes(StandardCharsets.UTF_8));
    }

    public String encrypt(String sharedSecret) {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)this.secretKey, this.parameterSpec);
        return Base64.getEncoder().encodeToString(cipher.doFinal(sharedSecret.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String encodedEncryptedSecret) {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)this.secretKey, this.parameterSpec);
        return new String(cipher.doFinal(Base64.getDecoder().decode(encodedEncryptedSecret)));
    }
}

