/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.model;

import java.io.Serializable;
import java.time.Instant;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.Assert;
import tiqr.org.model.NotificationType;
import tiqr.org.model.RegistrationStatus;

@Document(collection="registrations")
public class Registration
implements Serializable {
    @Id
    private String id;
    private String userId;
    private String userDisplayName;
    private String secret;
    private String enrollmentSecret;
    private String language;
    private String notificationType;
    private String notificationAddress;
    private String operation;
    private RegistrationStatus status;
    private Instant created;
    private Instant updated;
    private boolean useRegistrationId;

    public void validateForInitialEnrollment() {
        this.validateForPushNotification();
        Assert.hasLength((String)this.enrollmentSecret, (String)"enrollmentSecret is empty");
        Assert.notNull((Object)((Object)this.status), (String)"status is null");
    }

    public void validateForPushNotification() {
        Assert.hasLength((String)this.userId, (String)"userId is empty");
        Assert.hasLength((String)this.notificationType, (String)"notificationType is empty");
        Assert.hasLength((String)this.notificationAddress, (String)"notificationAddress is empty");
        NotificationType.valueOf(this.notificationType);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getEnrollmentSecret() {
        return this.enrollmentSecret;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public String getNotificationAddress() {
        return this.notificationAddress;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public RegistrationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @Generated
    public boolean isUseRegistrationId() {
        return this.useRegistrationId;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setEnrollmentSecret(String enrollmentSecret) {
        this.enrollmentSecret = enrollmentSecret;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    @Generated
    public void setNotificationAddress(String notificationAddress) {
        this.notificationAddress = notificationAddress;
    }

    @Generated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Generated
    public void setStatus(RegistrationStatus status) {
        this.status = status;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(Instant updated) {
        this.updated = updated;
    }

    @Generated
    public void setUseRegistrationId(boolean useRegistrationId) {
        this.useRegistrationId = useRegistrationId;
    }
}

