/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import tiqr.org.SecretCipher;
import tiqr.org.model.Authentication;
import tiqr.org.model.AuthenticationStatus;
import tiqr.org.model.Enrollment;
import tiqr.org.model.EnrollmentStatus;
import tiqr.org.model.Registration;
import tiqr.org.secure.Challenge;
import tiqr.org.secure.OCRA;

@Controller
public class TiqrEndpoint {
    private static final Log LOG = LogFactory.getLog(TiqrEndpoint.class);
    private final String environment;
    private final MongoTemplate mongoTemplate;
    private final String eduIDBaseUrl;
    private final RestTemplate restTemplate;
    private final SecretCipher secretCipher;

    @Autowired
    public TiqrEndpoint(MongoTemplate mongoTemplate, @Value(value="${eduid.base_url}") String eduIDBaseUrl, @Value(value="${environment}") String environment, @Value(value="${encryption_secret}") String encryptionSecret) {
        this.mongoTemplate = mongoTemplate;
        this.eduIDBaseUrl = eduIDBaseUrl;
        this.environment = environment;
        this.restTemplate = new RestTemplate();
        this.secretCipher = new SecretCipher(encryptionSecret);
    }

    @GetMapping(value={"/"})
    public ModelAndView index() {
        Map<String, String> body = Map.of("environment", this.environment);
        return new ModelAndView("index", body);
    }

    @GetMapping(value={"/enrollments"})
    public ModelAndView enrollments() {
        List enrollments = this.findAll(Enrollment.class, "status", EnrollmentStatus.INITIALIZED.name());
        Map<String, String> body = Map.of("enrollments", enrollments, "environment", this.environment);
        LOG.info((Object)String.format("Returning %s enrollments", enrollments.size()));
        return new ModelAndView("enrollments", body);
    }

    @GetMapping(value={"/enrollment/{key}"})
    public ModelAndView enrollment(@PathVariable(value="key") String key) {
        String url = String.format("%s/tiqr/metadata?enrollment_key=%s", this.eduIDBaseUrl, key);
        Map metaData = (Map)this.restTemplate.getForEntity(url, Map.class, new Object[0]).getBody();
        Enrollment enrollment = this.findEnrollment(key);
        Map<String, String> body = Map.of("enrollment", enrollment, "metadata", metaData, "environment", this.environment);
        LOG.info((Object)String.format("Returning enrollment for %s", enrollment.getUserDisplayName()));
        return new ModelAndView("enrollment", body);
    }

    @GetMapping(value={"/enrolled/{key}"})
    public View enrolled(@PathVariable(value="key") String key) {
        Enrollment enrollment = this.findEnrollment(key);
        String url = String.format("%s/tiqr/enrollment?enrollment_secret=%s", this.eduIDBaseUrl, enrollment.getEnrollmentSecret());
        HttpHeaders headers = this.getHttpHeaders();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"userId", (Object)enrollment.getUserID());
        map.add((Object)"secret", (Object)Challenge.generateSessionKey());
        map.add((Object)"language", (Object)"en");
        map.add((Object)"notificationType", (Object)"APNS");
        map.add((Object)"notificationAddress", (Object)"1234567890");
        map.add((Object)"version", (Object)"2");
        map.add((Object)"operation", (Object)"register");
        RequestEntity request = new RequestEntity((Object)map, (MultiValueMap)headers, HttpMethod.POST, URI.create(url));
        ResponseEntity responseEntity = this.restTemplate.exchange(request, Void.class);
        LOG.info((Object)String.format("Enrolled enrollment for %s with status %s", enrollment.getUserDisplayName(), responseEntity.getStatusCodeValue()));
        return new RedirectView("/enrollments");
    }

    @GetMapping(value={"/authentications"})
    public ModelAndView authentications() {
        List authentications = this.findAll(Authentication.class, "status", AuthenticationStatus.PENDING.name());
        authentications.addAll(this.findAll(Authentication.class, "status", AuthenticationStatus.SUSPENDED.name()));
        Map<String, String> body = Map.of("authentications", authentications, "environment", this.environment);
        return new ModelAndView("authentications", body);
    }

    @GetMapping(value={"/authentication/{sessionKey}"})
    public ModelAndView authentication(@PathVariable(value="sessionKey") String sessionKey) {
        Authentication authentication = this.findAuthentication(sessionKey);
        Registration registration = this.findRegistration(authentication.getUserID());
        String decryptedSecret = this.secretCipher.decrypt(registration.getSecret());
        String ocra = OCRA.generateOCRA((String)decryptedSecret, (String)authentication.getChallenge(), (String)sessionKey);
        Map<String, String> body = Map.of("authentication", authentication, "ocra", String.join((CharSequence)" ", Arrays.asList(ocra.split(""))), "environment", this.environment);
        LOG.info((Object)String.format("Returning authentication for %s", authentication.getUserID()));
        return new ModelAndView("authentication", body);
    }

    @GetMapping(value={"/authenticated/{sessionKey}"})
    public View authenticated(@PathVariable(value="sessionKey") String sessionKey, @RequestParam(name="fail", required=false, defaultValue="false") boolean fail) {
        Authentication authentication = this.findAuthentication(sessionKey);
        String url = String.format("%s/tiqr/authentication", this.eduIDBaseUrl);
        HttpHeaders headers = this.getHttpHeaders();
        Registration registration = this.findRegistration(authentication.getUserID());
        String decryptedSecret = this.secretCipher.decrypt(registration.getSecret());
        String ocra = OCRA.generateOCRA((String)decryptedSecret, (String)authentication.getChallenge(), (String)sessionKey);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"sessionKey", (Object)sessionKey);
        map.add((Object)"userId", (Object)authentication.getUserID());
        map.add((Object)"response", (Object)(fail ? "nope" : ocra));
        map.add((Object)"language", (Object)"nl");
        map.add((Object)"operation", (Object)"login");
        map.add((Object)"notificationType", (Object)"APNS");
        map.add((Object)"notificationAddress", (Object)"1234567890");
        RequestEntity request = new RequestEntity((Object)map, (MultiValueMap)headers, HttpMethod.POST, URI.create(url));
        this.restTemplate.exchange(request, Void.class);
        return new RedirectView((String)(fail ? "/authentication/" + sessionKey : "/enrollments"));
    }

    @GetMapping(value={"/registrations"})
    public ModelAndView registrations() {
        List registrations = this.mongoTemplate.find(new Query(), Registration.class, "registrations");
        Map<String, String> body = Map.of("registrations", registrations, "environment", this.environment);
        return new ModelAndView("registrations", body);
    }

    @GetMapping(value={"/registration/{userId}"})
    public ModelAndView registration(@PathVariable(value="userId") String userId) {
        Registration registration = this.findRegistration(userId);
        Map<String, String> body = Map.of("registration", registration, "environment", this.environment);
        return new ModelAndView("registration", body);
    }

    @GetMapping(value={"/delete-registration/{userId}"})
    public View deleteRegistration(@PathVariable(value="userId") String userId) {
        Registration registration = this.findRegistration(userId);
        this.mongoTemplate.remove((Object)registration);
        Map user = (Map)this.mongoTemplate.findById((Object)userId, Map.class, "users");
        Map surfSecureId = (Map)user.get("surfSecureId");
        surfSecureId.clear();
        user.put("lastSeenAppNudge", 1L);
        this.mongoTemplate.save((Object)user, "users");
        return new RedirectView("/registrations");
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    private Enrollment findEnrollment(String key) {
        return (Enrollment)this.findOne(Enrollment.class, "key", key);
    }

    private Authentication findAuthentication(String sessionKey) {
        return (Authentication)this.findOne(Authentication.class, "sessionKey", sessionKey);
    }

    private Registration findRegistration(String userId) {
        return (Registration)this.findOne(Registration.class, "userId", userId);
    }

    private <T> T findOne(Class<T> clazz, String attribute, String value) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)attribute).is((Object)value));
        Document document = (Document)AnnotationUtils.findAnnotation(clazz, Document.class);
        return (T)this.mongoTemplate.findOne(query, clazz, document.collection());
    }

    private <T> List<T> findAll(Class<T> clazz, String attribute, String value) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)attribute).is((Object)value));
        Document document = (Document)AnnotationUtils.findAnnotation(clazz, Document.class);
        return this.mongoTemplate.find(query, clazz, document.collection());
    }
}

