/*
 * Decompiled with CFR 0.152.
 */
package voot;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import voot.provider.Provider;
import voot.valueobject.Group;

public class ExternalGroupsService {
    private final List<Provider> providers;
    private final ForkJoinPool forkJoinPool;

    public ExternalGroupsService(List<Provider> providers) {
        Preconditions.checkArgument((providers.size() > 0 ? 1 : 0) != 0, (Object)"No clients configured");
        this.providers = providers;
        this.forkJoinPool = new ForkJoinPool(providers.size() * 20);
    }

    public List<Group> getMyGroups(String uid, String schacHomeOrganization) {
        Predicate<Provider> providerFilter = provider -> provider.shouldBeQueriedForMemberships(schacHomeOrganization);
        return this.doGetGroups(uid, providerFilter);
    }

    public List<Group> getMyExternalGroups(String uid, String schacHomeOrganization) {
        Predicate<Provider> providerFilter = provider -> provider.isExternalGroupProvider() && provider.shouldBeQueriedForMemberships(schacHomeOrganization);
        return this.doGetGroups(uid, providerFilter);
    }

    public Optional<Group> getMyGroupById(String uid, String groupId, String schacHomeOrganization) {
        try {
            List optionals = (List)((ForkJoinTask)this.forkJoinPool.submit(() -> this.providers.parallelStream().filter(provider -> provider.shouldBeQueriedForGroup(schacHomeOrganization, groupId)).map(provider -> provider.getGroupMembership(uid, groupId)).filter(optionalGroup -> optionalGroup.isPresent()).collect(Collectors.toList()))).get();
            return optionals.isEmpty() ? Optional.empty() : (Optional)optionals.get(0);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of external group providers.", e);
        }
    }

    private List<Group> doGetGroups(String uid, Predicate<Provider> providerFilter) {
        try {
            return (List)((ForkJoinTask)this.forkJoinPool.submit(() -> this.providers.parallelStream().filter(providerFilter).map(provider -> provider.getGroupMemberships(uid)).flatMap(Collection::stream).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of external group providers.", e);
        }
    }
}

