/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import voot.provider.GroupProviderType;
import voot.provider.Provider;

public abstract class AbstractProvider
implements Provider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProvider.class);
    protected final RestTemplate restTemplate;
    protected final Provider.Configuration configuration;
    protected final String groupIdPrefix;
    protected static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public AbstractProvider(Provider.Configuration configuration) {
        this.configuration = configuration;
        this.restTemplate = new RestTemplate(this.getRequestFactory());
        this.groupIdPrefix = String.format("urn:collab:group:%s:", configuration.schacHomeOrganization);
        LOG.debug("Initializing {} {}", this.getClass(), (Object)configuration);
    }

    @Override
    public boolean isExternalGroupProvider() {
        return !this.configuration.type.equals((Object)GroupProviderType.GROUPER);
    }

    protected <T> T parseJson(String json, Class<T> t) {
        try {
            return (T)objectMapper.readValue(json, t);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing Json", e);
        }
    }

    private ClientHttpRequestFactory getRequestFactory() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.credentials.username, this.configuration.credentials.password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.configuration.timeOutMillis.intValue()).setConnectTimeout(this.configuration.timeOutMillis.intValue()).setSocketTimeout(this.configuration.timeOutMillis.intValue()).build());
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }

    public String toString() {
        return String.format("Provider with configuration: %s", this.configuration);
    }
}

