/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import voot.provider.AbstractProvider;
import voot.provider.GrouperNameSpaceContext;
import voot.provider.Provider;
import voot.util.UrnUtils;
import voot.valueobject.Group;
import voot.valueobject.Membership;

public class GrouperSoapClient
extends AbstractProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GrouperSoapClient.class);
    private final NamespaceContext grouperNameSpaceContext = new GrouperNameSpaceContext();
    private final Pattern replacementPattern = Pattern.compile("\\[(.+?)\\]");
    private final Charset charSet = Charset.forName("UTF-8");
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final Map<String, String> soapTemplates = new HashMap<String, String>();

    public GrouperSoapClient(Provider.Configuration configuration) {
        super(configuration);
        this.factory.setNamespaceAware(true);
    }

    @Override
    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return true;
    }

    @Override
    public boolean shouldBeQueriedForGroup(String schacHomeOrganization, String groupId) {
        Matcher matcher = UrnUtils.GROUP_PATTERN.matcher(groupId);
        return matcher.matches() && matcher.group(1).equals(this.configuration.schacHomeOrganization);
    }

    @Override
    public List<Group> getGroupMemberships(String uid) {
        ImmutableMap replacements = ImmutableMap.of((Object)"subjectId", (Object)uid);
        try {
            LOG.debug("Querying getGroupMemberships for subjectId: {}", (Object)uid);
            String soap = this.replaceTokens("soap/GetGroupsLite.xml", (Map<String, String>)replacements);
            ResponseEntity<String> response = this.getGrouperResponse(soap);
            List<Group> groups = this.parseGroups(response);
            LOG.debug("getGroupMemberships result: {} groups.", (Object)groups.size());
            return groups;
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke getGroupMemberships, returning empty result.", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<Group> getGroupMembership(String uid, String groupId) {
        Optional<String> localGroupId = UrnUtils.extractLocalGroupId(groupId);
        if (!localGroupId.isPresent()) {
            throw new IllegalArgumentException("Unable to infer localgroupId from " + groupId);
        }
        ImmutableMap replacements = ImmutableMap.of((Object)"subjectId", (Object)uid, (Object)"groupId", (Object)localGroupId.get());
        try {
            LOG.debug("Querying getGroupMembership API for subjectId: {}", (Object)uid);
            String soap = this.replaceTokens("soap/HasMemberLite.xml", (Map<String, String>)replacements);
            ResponseEntity<String> response = this.getGrouperResponse(soap);
            Optional<Group> group = this.parseOptionalGroupMembership(response);
            LOG.debug("getGroupMembership result: {} group.", group);
            return group;
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke grouper, returning empty result.", (Throwable)exception);
            return Optional.empty();
        }
    }

    private ResponseEntity<String> getGrouperResponse(String soap) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_XML);
        HttpEntity entity = new HttpEntity((Object)soap, (MultiValueMap)headers);
        return this.restTemplate.exchange(this.configuration.url, HttpMethod.POST, entity, String.class, new Object[0]);
    }

    private List<Group> parseGroups(ResponseEntity<String> response) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        LOG.debug("result from Grouper: {} .", response);
        Document document = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(((String)response.getBody()).getBytes()));
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this.grouperNameSpaceContext);
        NodeList nodes = (NodeList)xpath.evaluate("//ns:wsGroups", document, XPathConstants.NODESET);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!this.nonNilNode(item)) continue;
            groups.add(this.parseGroup(xpath, item));
        }
        return groups;
    }

    private boolean nonNilNode(Node node) {
        Node attribute = node.getAttributes().getNamedItem("xsi:nil");
        return attribute == null || Boolean.valueOf(attribute.getNodeValue()) == false;
    }

    private Group parseGroup(XPath xpath, Node item) throws XPathExpressionException {
        return new Group(this.groupIdPrefix + xpath.evaluate("ns:name", item), xpath.evaluate("ns:displayExtension", item), xpath.evaluate("ns:description", item), this.configuration.name, Membership.defaultMembership);
    }

    private Optional<Group> parseOptionalGroupMembership(ResponseEntity<String> response) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        Document document = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(((String)response.getBody()).getBytes()));
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this.grouperNameSpaceContext);
        String resultCode = (String)xpath.evaluate("//ns:resultCode[1]", document, XPathConstants.STRING);
        if (resultCode.equals("IS_MEMBER")) {
            Node group = (Node)xpath.evaluate("//ns:wsGroup[1]", document, XPathConstants.NODE);
            return Optional.of(this.parseGroup(xpath, group));
        }
        return Optional.empty();
    }

    private String replaceTokens(String soapTemplate, Map<String, String> replacements) throws IOException {
        String xml = this.soapTemplates.get(soapTemplate);
        if (xml == null) {
            xml = StreamUtils.copyToString((InputStream)new ClassPathResource(soapTemplate).getInputStream(), (Charset)this.charSet);
            this.soapTemplates.put(soapTemplate, xml);
        }
        Matcher matcher = this.replacementPattern.matcher(xml);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, "");
            buffer.append(replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

