/*
 * Decompiled with CFR 0.152.
 */
package voot.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrnUtils {
    public static final String URN_COLLAB_GROUP_REGEXP = "^urn:collab:group:([^:]+):(.+)$";
    public static final Pattern GROUP_PATTERN = Pattern.compile("^urn:collab:group:([^:]+):(.+)$");
    public static final String URN_COLLAB_PERSON_REGEXP = "^urn:collab:person:([^:]+):(.+)$";
    public static final Pattern PERSON_PATTERN = Pattern.compile("^urn:collab:person:([^:]+):(.+)$");

    public static Optional<String> extractLocalGroupId(String groupId) {
        return UrnUtils.getIdFromRegExp(GROUP_PATTERN, groupId);
    }

    public static Optional<String> extractLocalUid(String uid) {
        return UrnUtils.getIdFromRegExp(PERSON_PATTERN, uid);
    }

    public static Optional<String> getSchacHomeFromGroupUrn(String groupId) {
        return UrnUtils.getSchacHomeFromRegExp(GROUP_PATTERN, groupId);
    }

    public static Optional<String> getSchacHomeFromPersonUrn(String personId) {
        return UrnUtils.getSchacHomeFromRegExp(PERSON_PATTERN, personId);
    }

    public static boolean isFullyQualifiedGroupName(String groupId) {
        return GROUP_PATTERN.matcher(groupId).matches();
    }

    private static Optional<String> getIdFromRegExp(Pattern pattern, String id) {
        Matcher m = pattern.matcher(id);
        if (m.matches()) {
            return Optional.of(m.group(2));
        }
        return Optional.empty();
    }

    private static Optional<String> getSchacHomeFromRegExp(Pattern pattern, String id) {
        Matcher m = pattern.matcher(id);
        if (m.matches()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }
}

