/*
 * Decompiled with CFR 0.152.
 */
package voot.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.util.Assert;
import voot.oauth.DecisionResourceServerTokenServices;

public class CachedRemoteTokenServices
implements DecisionResourceServerTokenServices {
    private static final Logger LOG = LoggerFactory.getLogger(CachedRemoteTokenServices.class);
    private final Map<String, CachedOAuth2Authentication> authentications = new ConcurrentHashMap<String, CachedOAuth2Authentication>();
    private final long duration;
    private final DecisionResourceServerTokenServices tokenServices;

    public CachedRemoteTokenServices(DecisionResourceServerTokenServices tokenServices, long durationMilliseconds, long expiryIntervalCheckMilliseconds) {
        this.tokenServices = tokenServices;
        Assert.isTrue((durationMilliseconds > 0L && durationMilliseconds < 3660000L ? 1 : 0) != 0);
        Assert.isTrue((expiryIntervalCheckMilliseconds > 0L && expiryIntervalCheckMilliseconds < 3660000L ? 1 : 0) != 0);
        this.duration = durationMilliseconds;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::clearExpiredAuthentications, 0L, expiryIntervalCheckMilliseconds, TimeUnit.MILLISECONDS);
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        CachedOAuth2Authentication cachedAuthentication = this.authentications.get(accessToken);
        long now = System.currentTimeMillis();
        if (cachedAuthentication != null && cachedAuthentication.timestamp + this.duration > now) {
            LOG.debug("Returning OAuth2Authentication from cache {}", (Object)cachedAuthentication.authentication);
            return cachedAuthentication.authentication;
        }
        OAuth2Authentication oAuth2Authentication = this.tokenServices.loadAuthentication(accessToken);
        int size = this.authentications.size();
        if (size < 10000) {
            LOG.debug("Putting OAuth2Authentication in cache {} current size: {}", (Object)oAuth2Authentication, (Object)(size + 1));
            this.authentications.put(accessToken, new CachedOAuth2Authentication(now, oAuth2Authentication));
        }
        return oAuth2Authentication;
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        return this.tokenServices.readAccessToken(accessToken);
    }

    private void clearExpiredAuthentications() {
        try {
            long now = System.currentTimeMillis();
            this.authentications.forEach((accessToken, authentication) -> {
                if (authentication.timestamp + this.duration < now) {
                    LOG.debug("Removing expired authentication with access token {}", accessToken);
                    this.authentications.remove(accessToken);
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Error in clearExpiredAuthentications", t);
        }
    }

    @Override
    public boolean canHandle(String accessToken) {
        return this.tokenServices.canHandle(accessToken);
    }

    private class CachedOAuth2Authentication {
        long timestamp;
        OAuth2Authentication authentication;

        public CachedOAuth2Authentication(long timestamp, OAuth2Authentication authentication) {
            this.timestamp = timestamp;
            this.authentication = authentication;
        }
    }
}

