/*
 * Decompiled with CFR 0.152.
 */
package voot.oauth;

import java.util.List;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import voot.oauth.DecisionResourceServerTokenServices;

public class CompositeDecisionResourceServerTokenServices
implements DecisionResourceServerTokenServices {
    private final List<DecisionResourceServerTokenServices> tokenServices;

    public CompositeDecisionResourceServerTokenServices(List<DecisionResourceServerTokenServices> tokenServices) {
        this.tokenServices = tokenServices;
    }

    @Override
    public boolean canHandle(String accessToken) {
        for (DecisionResourceServerTokenServices tokenService : this.tokenServices) {
            if (!tokenService.canHandle(accessToken)) continue;
            return true;
        }
        return false;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        for (DecisionResourceServerTokenServices tokenService : this.tokenServices) {
            if (!tokenService.canHandle(accessToken)) continue;
            return tokenService.loadAuthentication(accessToken);
        }
        throw new InvalidTokenException("Can not handle accessToken " + accessToken);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        for (DecisionResourceServerTokenServices tokenService : this.tokenServices) {
            if (!tokenService.canHandle(accessToken)) continue;
            return tokenService.readAccessToken(accessToken);
        }
        throw new InvalidTokenException("Can not handle accessToken " + accessToken);
    }
}

