/*
 * Decompiled with CFR 0.152.
 */
package voot;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.authentication.BearerTokenExtractor;
import org.springframework.security.oauth2.provider.authentication.TokenExtractor;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import voot.ExternalGroupsService;
import voot.authz.AuthzResourceServerTokenServices;
import voot.authz.AuthzSchacHomeAwareUserAuthenticationConverter;
import voot.oauth.CachedRemoteTokenServices;
import voot.oauth.CompositeDecisionResourceServerTokenServices;
import voot.oauth.DecisionResourceServerTokenServices;
import voot.oidc.OidcRemoteTokenServices;
import voot.provider.GroupProviderType;
import voot.provider.GrouperSoapClient;
import voot.provider.OpenSocialClient;
import voot.provider.Provider;
import voot.provider.Voot2Provider;

@SpringBootApplication
public class VootServiceApplication {
    @Autowired
    private ResourceLoader resourceLoader;

    public static void main(String[] args) {
        SpringApplication.run(VootServiceApplication.class, (String[])args);
    }

    @Bean
    @Autowired
    public ExternalGroupsService externalGroupsService(@Value(value="${externalProviders.config.path}") String configFileLocation) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map config = (Map)yaml.load(this.resourceLoader.getResource(configFileLocation).getInputStream());
        List externalGroupProviders = (List)config.get("externalGroupProviders");
        List<Provider> groupClients = externalGroupProviders.stream().map(entryMap -> {
            String type = (String)entryMap.get("type");
            String url = StringUtils.trimTrailingCharacter((String)((String)entryMap.get("url")), (char)'/');
            String schacHomeOrganization = (String)entryMap.get("schacHomeOrganization");
            String name = (String)entryMap.get("name");
            Integer timeoutMillis = (Integer)entryMap.get("timeoutMillis");
            Map rawCredentials = (Map)entryMap.get("credentials");
            String username = (String)rawCredentials.get("username");
            String secret = (String)rawCredentials.get("secret");
            GroupProviderType groupProviderType = GroupProviderType.valueOf(type.toUpperCase());
            Provider.Configuration configuration = new Provider.Configuration(groupProviderType, url, new Provider.Configuration.Credentials(username, secret), timeoutMillis, schacHomeOrganization, name);
            switch (groupProviderType) {
                case VOOT2: {
                    return new Voot2Provider(configuration);
                }
                case OPEN_SOCIAL: {
                    return new OpenSocialClient(configuration);
                }
                case GROUPER: {
                    return new GrouperSoapClient(configuration);
                }
            }
            throw new IllegalArgumentException("Unknown external provider-type: " + type);
        }).collect(Collectors.toList());
        return new ExternalGroupsService(groupClients);
    }

    @Configuration
    @EnableResourceServer
    @EnableWebSecurity
    protected static class ResourceServerConfiguration
    extends ResourceServerConfigurerAdapter {
        @Value(value="${authz.checkToken.endpoint.url}")
        private String authzCheckTokenEndpointUrl;
        @Value(value="${authz.checkToken.clientId}")
        private String authzCheckTokenClientId;
        @Value(value="${authz.checkToken.secret}")
        private String authzCheckTokenSecret;
        @Value(value="${oidc.checkToken.endpoint.url}")
        private String oidcCheckTokenEndpointUrl;
        @Value(value="${oidc.checkToken.clientId}")
        private String oidcCheckTokenClientId;
        @Value(value="${oidc.checkToken.secret}")
        private String oidcCheckTokenSecret;
        @Value(value="${checkToken.cache}")
        private boolean checkTokenCache;
        @Value(value="${checkToken.cache.duration.milliSeconds}")
        private int checkTokenCacheDurationMilliseconds;

        protected ResourceServerConfiguration() {
        }

        public void configure(ResourceServerSecurityConfigurer resources) {
            resources.resourceId("groups").tokenServices((ResourceServerTokenServices)this.resourceServerTokenServices()).tokenExtractor(this.tokenExtractor());
        }

        private DecisionResourceServerTokenServices resourceServerTokenServices() {
            CompositeDecisionResourceServerTokenServices tokenServices = new CompositeDecisionResourceServerTokenServices(Arrays.asList(this.oidcResourceServerTokenServices(), this.authzResourceServerTokenServices()));
            return this.checkTokenCache ? new CachedRemoteTokenServices(tokenServices, this.checkTokenCacheDurationMilliseconds, this.checkTokenCacheDurationMilliseconds) : tokenServices;
        }

        private DecisionResourceServerTokenServices oidcResourceServerTokenServices() {
            return new OidcRemoteTokenServices(this.oidcCheckTokenEndpointUrl, this.oidcCheckTokenClientId, this.oidcCheckTokenSecret);
        }

        private DecisionResourceServerTokenServices authzResourceServerTokenServices() {
            DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter();
            accessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)new AuthzSchacHomeAwareUserAuthenticationConverter());
            return new AuthzResourceServerTokenServices(this.authzCheckTokenClientId, this.authzCheckTokenSecret, this.authzCheckTokenEndpointUrl, (AccessTokenConverter)accessTokenConverter);
        }

        private TokenExtractor tokenExtractor() {
            return new BearerTokenExtractor(){

                protected String extractToken(HttpServletRequest request) {
                    return this.extractHeaderToken(request);
                }
            };
        }

        public void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).authorizeRequests().antMatchers(new String[]{"/me/**", "groups/**", "internal/**"})).access("#oauth2.hasScope('groups')").antMatchers(new String[]{"/voot/**"})).access("#oauth2.hasScope('members')").antMatchers(new String[]{"/public/**", "/health/**", "/info/**"})).permitAll().antMatchers(new String[]{"/**"})).hasRole("USER");
        }
    }
}

