/*
 * Decompiled with CFR 0.152.
 */
package voot.oauth;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import voot.oauth.ClientCredentialsAuthentication;
import voot.oauth.SchacHomeAuthentication;

public class SchacHomeAwareUserAuthenticationConverter
extends DefaultUserAuthenticationConverter {
    private static final String SCHAC_HOME_KEY = "schacHomeOrganization";
    private static final String CLIENT_ID = "client_id";

    public Authentication extractAuthentication(Map<String, ?> authenticationAttributes) {
        Authentication authentication = super.extractAuthentication(authenticationAttributes);
        if (authentication == null) {
            Preconditions.checkArgument((boolean)authenticationAttributes.containsKey(CLIENT_ID), (String)"Authentication (%s) does not contain %s attribute", (Object[])new Object[]{authenticationAttributes, CLIENT_ID});
            return new ClientCredentialsAuthentication((String)authenticationAttributes.get(CLIENT_ID));
        }
        Preconditions.checkArgument((boolean)authenticationAttributes.containsKey(SCHAC_HOME_KEY), (String)"Authentication (%s) does not contain %s attribute", (Object[])new Object[]{authenticationAttributes, SCHAC_HOME_KEY});
        return new SchacHomeAuthentication((String)authenticationAttributes.get(SCHAC_HOME_KEY), authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
    }
}

