/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import voot.provider.AbstractProvider;
import voot.provider.GrouperSoapClient;
import voot.provider.Provider;
import voot.valueobject.Group;
import voot.valueobject.Membership;

public class Voot2Client
extends AbstractProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GrouperSoapClient.class);

    public Voot2Client(Provider.Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return this.configuration.schacHomeOrganization.equals(schacHomeOrganization);
    }

    @Override
    public boolean shouldBeQueriedForGroup(String schacHomeOrganization, String groupId) {
        return this.shouldBeQueriedForMemberships(schacHomeOrganization);
    }

    @Override
    public List<Group> getGroupMemberships(String uid) {
        LOG.info("Querying getGroupMemberships for subjectId: {} and name: {}", (Object)uid, (Object)this.configuration.schacHomeOrganization);
        uid = Voot2Client.stripPersonUrnIdentifier(uid);
        ResponseEntity response = this.restTemplate.getForEntity(String.format("%s/groups/{uid}", this.configuration.url), String.class, new Object[]{uid});
        if (response.getStatusCode().is2xxSuccessful()) {
            return this.parseGroups((String)response.getBody());
        }
        LOG.error("Failed to invoke getGroupMemberships {} for {}, returning empty result.", (Object)response, (Object)this.configuration);
        return Collections.emptyList();
    }

    @Override
    public Optional<Group> getGroupMembership(String uid, String groupId) {
        LOG.debug("Querying getGroupMembership for subjectId: {} and name: {}", (Object)uid, (Object)this.configuration.schacHomeOrganization);
        uid = Voot2Client.stripPersonUrnIdentifier(uid);
        groupId = Voot2Client.stripGroupUrnIdentifier(groupId);
        ResponseEntity response = this.restTemplate.getForEntity(String.format("%s/groups/{uid}/{groupId}", this.configuration.url), String.class, new Object[]{uid, groupId});
        if (response.getStatusCode().is2xxSuccessful()) {
            return this.parseSingleGroup((String)response.getBody());
        }
        LOG.error("Failed to invoke getGroupMemberships {} for {}, returning empty result.", (Object)response, (Object)this.configuration);
        return Optional.empty();
    }

    protected List<Group> parseGroups(String response) {
        List maps = this.parseJson(response, List.class);
        return maps.stream().map(item -> this.parseGroup((Map<String, Object>)item)).collect(Collectors.toList());
    }

    protected Optional<Group> parseSingleGroup(String response) {
        return Optional.of(this.parseGroup(this.parseJson(response, Map.class)));
    }

    private Group parseGroup(Map<String, Object> item) {
        return new Group(this.groupIdPrefix + item.get("id"), (String)item.get("displayName"), (String)item.get("description"), this.configuration.name, item.containsKey("membership") ? Membership.fromRole((String)((Map)item.get("membership")).get("basic")) : Membership.defaultMembership);
    }
}

