/*
 * Decompiled with CFR 0.152.
 */
package voot;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import voot.ExceptionProviderCallback;
import voot.ProviderCallback;
import voot.provider.Provider;
import voot.valueobject.Group;
import voot.valueobject.Member;

public class ExternalGroupsService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalGroupsService.class);
    private final List<Provider> providers;
    private final ForkJoinPool forkJoinPool;

    public ExternalGroupsService(List<Provider> providers) {
        Assert.isTrue((providers.size() > 0 ? 1 : 0) != 0, (String)"No clients configured");
        this.providers = providers;
        this.forkJoinPool = new ForkJoinPool(providers.size() * 20);
    }

    public List<Group> getMyGroups(String uid, String schacHomeOrganization) {
        return this.execute(provider -> provider.shouldBeQueriedForMemberships(schacHomeOrganization), provider -> provider.getGroupMemberships(uid), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Group> getMyExternalGroups(String uid, String schacHomeOrganization) {
        return this.execute(provider -> provider.isExternalGroupProvider() && provider.shouldBeQueriedForMemberships(schacHomeOrganization), provider -> provider.getGroupMemberships(uid), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Member> getMembers(String groupId) {
        return this.execute(provider -> provider.shouldBeQueriedForMembers(groupId), provider -> provider.getMembers(groupId), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Member> getMembers(String personId, String groupId) {
        return this.execute(provider -> provider.shouldBeQueriedForMembers(groupId), provider -> provider.getMembers(personId, groupId), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<Group> getMyGroupById(String uid, String groupId) {
        List groups = this.execute(provider -> provider.shouldBeQueriedForGroup(groupId), provider -> provider.getGroupMembership(uid, groupId), Optional::empty).filter(Optional::isPresent).collect(Collectors.toList());
        return groups.isEmpty() ? Optional.empty() : (Optional)groups.get(0);
    }

    public List<Group> getAllGroups() {
        return this.execute(provider -> !provider.isExternalGroupProvider(), Provider::getAllGroups, Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <T> Stream<T> execute(Predicate<Provider> providerFilter, ProviderCallback<T> callback, ExceptionProviderCallback<T> exceptionCallback) {
        try {
            return (Stream)((ForkJoinTask)this.forkJoinPool.submit(() -> this.providers.parallelStream().filter(providerFilter).map(provider -> {
                try {
                    return callback.execute((Provider)provider);
                }
                catch (RuntimeException e) {
                    LOG.warn("Provider {} threw exception: {} ", provider, (Object)e);
                    return exceptionCallback.result();
                }
            }))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of external group providers.", e);
        }
    }
}

