/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import voot.provider.AbstractProvider;
import voot.provider.GrouperDao;
import voot.provider.GrouperDaoClient;
import voot.provider.GrouperSoapParser;
import voot.provider.Provider;
import voot.util.UrnUtils;
import voot.valueobject.Group;
import voot.valueobject.Member;

public class GrouperSoapClient
extends AbstractProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GrouperSoapClient.class);
    public static final String URN_GET_GROUPS_LITE = "urn:getGroupsLite";
    public static final String URN_GET_MEMBERS_LITE = "urn:getMembersLite";
    public static final String URN_GET_GROUPER_PRIVILEGES_LITE = "urn:getGrouperPrivilegesLite";
    public static final String URN_HAS_MEMBER_LITE = "urn:hasMemberLite";
    public static final String URN_FIND_GROUPS_LITE = "urn:findGroupsLite";
    public static final String SOAP_ACTION = "SOAPAction";
    private final Pattern replacementPattern = Pattern.compile("\\[(.+?)\\]");
    private final Charset charSet = Charset.forName("UTF-8");
    private final Map<String, String> soapTemplates = new HashMap<String, String>();
    private final GrouperSoapParser soapParser;
    private final GrouperDao dao;

    public GrouperSoapClient(Provider.Configuration configuration, DataSource dataSource) {
        super(configuration);
        this.dao = new GrouperDaoClient(new JdbcTemplate(dataSource), configuration.name, this.groupIdPrefix);
        this.soapParser = new GrouperSoapParser(configuration.name, this.groupIdPrefix);
    }

    public GrouperSoapClient(Provider.Configuration configuration, GrouperDao grouperDao) {
        super(configuration);
        this.dao = grouperDao;
        this.soapParser = new GrouperSoapParser(configuration.name, this.groupIdPrefix);
    }

    @Override
    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return true;
    }

    @Override
    public List<Group> getGroupMemberships(String uid) {
        LOG.debug("Querying database getGroupMemberships for subjectId: {}", (Object)uid);
        try {
            return this.dao.groups(uid);
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke getGroupMemberships, returning empty result.", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<Group> getGroupMembership(String uid, String groupId) {
        Optional<String> localGroupId = this.getLocalGroupId(groupId);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("subjectId", uid);
        replacements.put("groupId", localGroupId.get());
        try {
            LOG.debug("Querying getGroupMembership API for subjectId: {}", (Object)uid);
            String soap = this.replaceTokens("soap/HasMemberLite.xml", replacements);
            ResponseEntity<String> response = this.getGrouperResponse(soap, URN_HAS_MEMBER_LITE);
            Optional<Group> group = this.soapParser.parseOptionalGroupMembership(response);
            LOG.debug("getGroupMembership result: {} group.", group);
            return group;
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke grouper, returning empty result.", (Throwable)exception);
            return Optional.empty();
        }
    }

    @Override
    public List<Group> getAllGroups() {
        try {
            LOG.debug("Querying findGroupsLite API");
            String soap = this.getTemplate("soap/FindGroupsLite.xml");
            ResponseEntity<String> response = this.getGrouperResponse(soap, URN_FIND_GROUPS_LITE);
            List<Group> group = this.soapParser.parseFindAllGroups(response);
            LOG.debug("getGroupMembership result: {} group.", (Object)group.size());
            return group;
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke grouper, returning empty result.", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Member> getMembers(String groupId) {
        Optional<String> localGroupId = this.getLocalGroupId(groupId);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("groupId", localGroupId.get());
        try {
            LOG.debug("Querying getMembers API for groupId: {}", (Object)localGroupId.get());
            String soap = this.replaceTokens("soap/GetMembersLite.xml", replacements);
            ResponseEntity<String> response = this.getGrouperResponse(soap, URN_GET_MEMBERS_LITE);
            List<Member> members = this.soapParser.parseMembers(response);
            LOG.debug("getMembers result: {} .", members);
            return members;
        }
        catch (Exception exception) {
            LOG.warn("Failed to invoke grouper, returning empty result.", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Member> getMembers(String personId, String groupId) {
        return this.getMembers(groupId);
    }

    private ResponseEntity<String> getGrouperResponse(String soap, String action) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_XML);
        headers.set(SOAP_ACTION, action);
        HttpEntity entity = new HttpEntity((Object)soap, (MultiValueMap)headers);
        return this.restTemplate.exchange(this.configuration.url, HttpMethod.POST, entity, String.class, new Object[0]);
    }

    private Optional<String> getLocalGroupId(String groupId) {
        Optional<String> localGroupId = UrnUtils.extractLocalGroupId(groupId);
        if (!localGroupId.isPresent()) {
            throw new IllegalArgumentException("Unable to infer localgroupId from " + groupId);
        }
        return localGroupId;
    }

    private String replaceTokens(String soapTemplate, Map<String, String> replacements) throws IOException {
        String xml = this.getTemplate(soapTemplate);
        Matcher matcher = this.replacementPattern.matcher(xml);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, "");
            buffer.append(replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String getTemplate(String soapTemplate) throws IOException {
        String xml = this.soapTemplates.get(soapTemplate);
        if (xml == null) {
            xml = StreamUtils.copyToString((InputStream)new ClassPathResource(soapTemplate).getInputStream(), (Charset)this.charSet);
            this.soapTemplates.put(soapTemplate, xml);
        }
        return xml;
    }
}

