/*
 * Decompiled with CFR 0.152.
 */
package voot;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import voot.ExceptionProviderCallback;
import voot.ProviderCallback;
import voot.provider.GrouperProvider;
import voot.provider.Provider;
import voot.provider.TeamsDao;
import voot.util.StreamUtils;
import voot.util.UrnUtils;
import voot.valueobject.Group;
import voot.valueobject.Member;

public class ExternalGroupsService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalGroupsService.class);
    private final List<Provider> providers;
    private final ForkJoinPool forkJoinPool;
    private final Optional<GrouperProvider> grouperProvider;
    private final TeamsDao teamsDao;
    private final boolean supportLinkedGrouperExternalGroups;

    public ExternalGroupsService(List<Provider> providers, TeamsDao teamsDao, boolean supportLinkedGrouperExternalGroups) {
        Assert.isTrue((providers.size() > 0 ? 1 : 0) != 0, (String)"No clients configured");
        this.providers = providers;
        this.teamsDao = teamsDao;
        this.forkJoinPool = new ForkJoinPool(providers.size() * 20);
        this.grouperProvider = this.providers.stream().filter(provider -> provider instanceof GrouperProvider).map(GrouperProvider.class::cast).findAny();
        this.supportLinkedGrouperExternalGroups = supportLinkedGrouperExternalGroups;
    }

    public Set<Group> getMyGroups(String uid, String schacHomeOrganization) {
        List<Group> groups = this.execute(provider -> provider.shouldBeQueriedForMemberships(schacHomeOrganization), provider -> provider.getGroupMemberships(uid), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.supportLinkedGrouperExternalGroups && this.grouperProvider.isPresent()) {
            GrouperProvider grouper = this.grouperProvider.get();
            String[] externalGroupIds = (String[])groups.stream().filter(group -> !grouper.isGrouperGroup(group.id)).map(group -> group.id).toArray(String[]::new);
            String[] grouperGroupIds = (String[])this.teamsDao.linkedLocalGrouperGroupIds(externalGroupIds).stream().toArray(String[]::new);
            List<Group> groupsFromGrouper = grouper.getGroupMembershipsForLocalGroupId(grouperGroupIds);
            groups.addAll(groupsFromGrouper);
        }
        return this.filterDuplicatesWithLowerImportance(groups);
    }

    public Set<Group> getMyExternalGroups(String uid, String schacHomeOrganization) {
        return this.execute(provider -> provider.isExternalGroupProvider() && provider.shouldBeQueriedForMemberships(schacHomeOrganization), provider -> provider.getGroupMemberships(uid), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Member> getMembers(String groupId) {
        return this.execute(provider -> provider.shouldBeQueriedForMembers(groupId), provider -> provider.getMembers(groupId), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Member> getMembers(String personId, String groupId) {
        return this.execute(provider -> provider.shouldBeQueriedForMembers(groupId), provider -> provider.getMembers(personId, groupId), Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Optional<Group> getMyGroupById(String uid, String groupId) {
        return this.doGetMyGroupById(uid, groupId, true);
    }

    private Optional<Group> doGetMyGroupById(String uid, String groupId, boolean tryExternalLinkedGroups) {
        String localGroupId;
        List<Group> externalGroups;
        List grouperGroups;
        GrouperProvider grouper;
        List groups = this.execute(provider -> provider.shouldBeQueriedForGroup(groupId), provider -> provider.getGroupMembership(uid, groupId), Optional::empty).filter(Optional::isPresent).collect(Collectors.toList());
        if (groups.isEmpty() && tryExternalLinkedGroups && this.supportLinkedGrouperExternalGroups && this.grouperProvider.isPresent() && (grouper = this.grouperProvider.get()).isGrouperGroup(groupId) && !(grouperGroups = (externalGroups = this.teamsDao.linkedExternalGroups(localGroupId = UrnUtils.extractLocalGroupId(groupId))).stream().map(externalGroup -> this.doGetMyGroupById(uid, externalGroup.id, false)).collect(Collectors.toList())).isEmpty()) {
            groups.add(this.findGroupByLocalGroupId(grouper, localGroupId));
        }
        return StreamUtils.optionalFromOptionalList(groups);
    }

    private Optional<Group> findGroupByLocalGroupId(GrouperProvider grouper, String localGroupId) {
        List<Group> groupsFromGrouper = grouper.getGroupMembershipsForLocalGroupId(localGroupId);
        return StreamUtils.optionalFromList(groupsFromGrouper);
    }

    public Set<Group> getAllGroups() {
        return this.execute(provider -> !provider.isExternalGroupProvider(), Provider::getAllGroups, Collections::emptyList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected Set<Group> filterDuplicatesWithLowerImportance(List<Group> groups) {
        return groups.stream().collect(Collectors.groupingBy(group -> group.id)).values().stream().map(grouped -> {
            grouped.sort(Comparator.comparing(group -> group.membership));
            return (Group)grouped.get(grouped.size() - 1);
        }).collect(Collectors.toSet());
    }

    private <T> Stream<T> execute(Predicate<Provider> providerFilter, ProviderCallback<T> callback, ExceptionProviderCallback<T> exceptionCallback) {
        try {
            return (Stream)((ForkJoinTask)this.forkJoinPool.submit(() -> this.providers.parallelStream().filter(providerFilter).map(provider -> {
                try {
                    return callback.execute((Provider)provider);
                }
                catch (RuntimeException e) {
                    LOG.warn("Provider {} threw exception: {} ", provider, (Object)e);
                    return exceptionCallback.result();
                }
            }))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of external group providers.", e);
        }
    }
}

