/*
 * Decompiled with CFR 0.152.
 */
package voot.web;

import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import voot.AccessDeniedException;
import voot.ExternalGroupsService;
import voot.ResourceNotFoundException;
import voot.oauth.ClientCredentialsAuthentication;
import voot.oauth.SchacHomeAuthentication;
import voot.util.UrnUtils;
import voot.valueobject.Group;
import voot.valueobject.Member;
import voot.web.VootController;

@RestController
public class VootController {
    private static Logger LOG = LoggerFactory.getLogger(VootController.class);
    private ExternalGroupsService externalGroupsService;

    @Autowired
    public VootController(ExternalGroupsService externalGroupsService) {
        this.externalGroupsService = externalGroupsService;
    }

    @RequestMapping(value={"/me/groups"})
    public Set<Group> myGroups(OAuth2Authentication authentication) {
        String schacHome = ((SchacHomeAuthentication)authentication.getUserAuthentication()).getSchacHomeAuthentication();
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("me/groups on behalf of uid: {}, schacHomeOrg: {}, accessToken: {}, clientId: {}", new Object[]{authentication.getName(), schacHome, accessToken, clientId});
        Set myGroups = this.externalGroupsService.getMyGroups(authentication.getName(), schacHome);
        LOG.debug("me/groups result for uid {}: {}", (Object)authentication.getName(), (Object)myGroups);
        return myGroups;
    }

    @RequestMapping(value={"/me/groups/{groupId:.+}"})
    public Group specificGroupMembership(@PathVariable String groupId, OAuth2Authentication authentication) throws MalformedGroupUrnException {
        String schacHome = ((SchacHomeAuthentication)authentication.getUserAuthentication()).getSchacHomeAuthentication();
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("groups/{} on behalf of uid {}, schacHomeOrg: {}, accessToken: {}, clientId {}", new Object[]{groupId, authentication.getName(), schacHome, accessToken, clientId});
        if (!UrnUtils.isFullyQualifiedGroupName((String)groupId)) {
            throw new MalformedGroupUrnException(groupId);
        }
        Optional group = this.externalGroupsService.getMyGroupById(authentication.getName(), groupId);
        LOG.debug("groups/{} result for uid {}: {}", new Object[]{groupId, authentication.getName(), group});
        return (Group)group.orElseThrow(ResourceNotFoundException::new);
    }

    @RequestMapping(value={"/internal/groups/{userId:.+}/{groupId:.+}"})
    public Group internalSpecificGroup(@PathVariable String userId, @PathVariable String groupId, OAuth2Authentication authentication) throws MalformedGroupUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("internal/groups/{}/{}, accessToken: {}, clientId {}", new Object[]{userId, groupId, accessToken, clientId});
        this.assertClientCredentialsClient(authentication, clientId);
        Optional group = this.externalGroupsService.getMyGroupById(userId, groupId);
        LOG.debug("groups/{} result: {}", (Object)groupId, (Object)group);
        return (Group)group.orElseThrow(ResourceNotFoundException::new);
    }

    @RequestMapping(value={"/internal/groups/{userId:.+}"})
    public Set<Group> internalGroups(@PathVariable String userId, OAuth2Authentication authentication) throws MalformedPersonUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("internal/groups/{}, accessToken: {}, clientId {}", new Object[]{userId, accessToken, clientId});
        this.assertClientCredentialsClient(authentication, clientId);
        String schacHome = UrnUtils.getSchacHomeFromPersonUrn((String)userId);
        Set myGroups = this.externalGroupsService.getMyGroups(userId, schacHome);
        LOG.debug("internal/groups/{} result: {}", (Object)userId, (Object)myGroups);
        return myGroups;
    }

    @RequestMapping(value={"/internal/external-groups/{userId:.+}"})
    public Set<Group> externalGroups(@PathVariable String userId, OAuth2Authentication authentication) throws MalformedPersonUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("internal/external-groups/{}, accessToken: {}, clientId {}", new Object[]{userId, accessToken, clientId});
        this.assertClientCredentialsClient(authentication, clientId);
        String schacHome = UrnUtils.getSchacHomeFromPersonUrn((String)userId);
        Set groups = this.externalGroupsService.getMyExternalGroups(userId, schacHome);
        LOG.debug("internal/external-groups/{} result: {}", (Object)userId, (Object)groups);
        return groups;
    }

    @RequestMapping(value={"/internal/all-groups"})
    public Set<Group> allGroups(OAuth2Authentication authentication) throws MalformedPersonUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("internal/all-groups, accessToken: {}, clientId {}", (Object)accessToken, (Object)clientId);
        this.assertClientCredentialsClient(authentication, clientId);
        Set groups = this.externalGroupsService.getAllGroups();
        LOG.debug("internal/all-groupsresult: {}", (Object)groups.size());
        return groups;
    }

    @RequestMapping(value={"/members/{groupId:.+}"})
    public Set<Member> members(@PathVariable String groupId, OAuth2Authentication authentication) throws MalformedPersonUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("members/{}, accessToken: {}, clientId {}", new Object[]{groupId, accessToken, clientId});
        this.assertClientCredentialsClient(authentication, clientId);
        Set members = this.externalGroupsService.getMembers(groupId);
        LOG.debug("/members/{} result: {}", (Object)groupId, (Object)members);
        return members;
    }

    @RequestMapping(value={"/members/{personId:.+}/{groupId:.+}"})
    public Set<Member> membersIncExternalMembers(@PathVariable String personId, @PathVariable String groupId, OAuth2Authentication authentication) throws MalformedPersonUrnException {
        String accessToken = ((OAuth2AuthenticationDetails)authentication.getDetails()).getTokenValue();
        String clientId = authentication.getOAuth2Request().getClientId();
        LOG.debug("members/{}, accessToken: {}, clientId {}", new Object[]{groupId, accessToken, clientId});
        this.assertClientCredentialsClient(authentication, clientId);
        Set members = this.externalGroupsService.getMembers(personId, groupId);
        LOG.debug("/members/{}/{} result: {}", new Object[]{personId, groupId, members});
        return members;
    }

    private void assertClientCredentialsClient(OAuth2Authentication authentication, String clientId) {
        if (!(authentication.getUserAuthentication() instanceof ClientCredentialsAuthentication)) {
            throw new AccessDeniedException(String.format("ClientCredentials grant type required. ClientId is %s", clientId));
        }
    }

    @ExceptionHandler(value={MalformedUrnException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ModelMap handleMalformedPersonUrnException(MalformedUrnException exception) {
        ModelMap model = new ModelMap();
        model.put((Object)"error", (Object)exception.getMessage());
        return model;
    }
}

