/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import voot.provider.GroupProviderType;
import voot.provider.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import voot.provider.Provider;
import voot.provider.ProviderResponseErrorHandler;
import voot.util.UrnUtils;
import voot.web.VootController;

public abstract class AbstractProvider
implements Provider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProvider.class);
    protected final RestTemplate restTemplate;
    protected final Provider.Configuration configuration;
    protected final String groupIdPrefix;
    protected static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public AbstractProvider(Provider.Configuration configuration) {
        this.configuration = configuration;
        try {
            this.restTemplate = new RestTemplate(this.getRequestFactory());
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new ProviderResponseErrorHandler());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.groupIdPrefix = String.format("urn:collab:group:%s:", configuration.schacHomeOrganization);
        LOG.debug("Initializing {} {}", this.getClass(), (Object)configuration);
    }

    public boolean isExternalGroupProvider() {
        return !this.configuration.type.equals((Object)GroupProviderType.TEAMS);
    }

    public boolean shouldBeQueriedForGroup(String groupId) {
        Matcher matcher = UrnUtils.GROUP_PATTERN.matcher(groupId);
        return matcher.matches() && matcher.group(1).equals(this.configuration.schacHomeOrganization);
    }

    public boolean shouldBeQueriedForMembers(String groupId) throws VootController.MalformedGroupUrnException {
        return !this.isExternalGroupProvider();
    }

    protected <T> T parseJson(String json, Class<T> t) {
        try {
            return (T)objectMapper.readValue(json, t);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing Json", e);
        }
    }

    protected <T, U> T handleResponse(ResponseEntity<U> response, Function<U, T> parseFunction, String methodName, T defaultValue) {
        if (response.getStatusCode().is2xxSuccessful()) {
            return parseFunction.apply(response.getBody());
        }
        LOG.error("Failed to invoke {}. Reponse is {} with configuration {}, returning empty result.", new Object[]{methodName, response, this.configuration});
        return defaultValue;
    }

    private ClientHttpRequestFactory getRequestFactory() throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.credentials.username, this.configuration.credentials.password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.configuration.timeOutMillis.intValue()).setConnectTimeout(this.configuration.timeOutMillis.intValue()).setSocketTimeout(this.configuration.timeOutMillis.intValue()).build());
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.configuration.url);
    }

    public String toString() {
        return String.format("Provider with configuration: %s", this.configuration);
    }

    public String getGroupIdPrefix() {
        return this.groupIdPrefix;
    }
}

