/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import voot.provider.Provider;
import voot.provider.Voot2Provider;
import voot.valueobject.Group;
import voot.valueobject.Membership;

public class OpenSocialClient
extends Voot2Provider {
    public OpenSocialClient(Provider.Configuration configuration) {
        super(configuration);
        this.allMembershipsUrlTemplate = "%s/groups/{uid}";
        this.specificMembershipTemplate = "%s/groups/{uid}/{groupId}";
    }

    protected List<Group> parseGroups(String response) {
        List groups = (List)((Map)this.parseJson(response, Map.class)).get("entry");
        if (groups == null) {
            LOG.info("Null response for groups while parsing {}", (Object)response);
            return new ArrayList<Group>();
        }
        return groups.stream().map(map -> {
            Object idHolder = map.get("id");
            String id = this.groupIdPrefix + (idHolder instanceof Map ? ((Map)idHolder).get("groupId") : idHolder);
            return new Group(id, (String)map.get("title"), (String)map.get("description"), this.configuration.name, new Membership(map.getOrDefault("voot_membership_role", "member")));
        }).collect(Collectors.toList());
    }

    protected Optional<Group> parseSingleGroup(String response) {
        List groups = this.parseGroups(response);
        return groups.isEmpty() ? Optional.empty() : Optional.of(groups.get(0));
    }
}

