/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import voot.provider.OpenSocialClient;
import voot.provider.Provider;
import voot.util.UrnUtils;
import voot.valueobject.Member;

public class OpenSocialMembersClient
extends OpenSocialClient {
    private final String membersTemplate;

    public OpenSocialMembersClient(Provider.Configuration configuration) {
        super(configuration);
        this.membersTemplate = "%s/people/{uid}/{groupId}";
    }

    public boolean shouldBeQueriedForMembers(String groupId) {
        return true;
    }

    public List<Member> getMembers(String personId, String groupId) {
        LOG.debug("Querying getMembers for personId: {} and groupId: {}", (Object)personId, (Object)groupId);
        String localGroupId = UrnUtils.extractLocalGroupId((String)groupId);
        String localPersonId = UrnUtils.extractLocalUid((String)personId);
        String url = String.format(this.membersTemplate, this.configuration.url);
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[]{localPersonId, localGroupId});
        return (List)this.handleResponse(response, arg_0 -> this.parseMembers(arg_0), "getMembers", Collections.emptyList());
    }

    private List<Member> parseMembers(String body) {
        List entries = (List)((Map)((Map)this.parseJson(body, Map.class)).get("result")).get("entry");
        return entries.stream().map(map -> {
            String id = (String)map.get("id");
            String name = (String)((Map)map.get("name")).get("formatted");
            List emails = (List)map.get("emails");
            return new Member(id, name, emails != null && !emails.isEmpty() ? (String)emails.get(0) : null);
        }).collect(Collectors.toList());
    }
}

