/*
 * Decompiled with CFR 0.152.
 */
package voot.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import voot.web.VootController;

/*
 * Exception performing whole class analysis ignored.
 */
public class UrnUtils {
    public static final String URN_COLLAB_GROUP_REGEXP = "^urn:collab:group:([^:]+):(.+)$";
    public static final Pattern GROUP_PATTERN = Pattern.compile("^urn:collab:group:([^:]+):(.+)$");
    public static final String URN_COLLAB_PERSON_REGEXP = "^urn:collab:person:([^:]+):(.+)$";
    public static final Pattern PERSON_PATTERN = Pattern.compile("^urn:collab:person:([^:]+):(.+)$");

    public static String extractLocalGroupId(String groupId) {
        return (String)UrnUtils.getIdFromRegExp((Pattern)GROUP_PATTERN, (String)groupId).orElseThrow(() -> new IllegalArgumentException("Unable to extract local group id from:" + groupId));
    }

    public static String extractLocalUid(String uid) {
        return (String)UrnUtils.getIdFromRegExp((Pattern)PERSON_PATTERN, (String)uid).orElseThrow(() -> new IllegalArgumentException("Unable to extract local uid from " + uid));
    }

    public static String getSchacHomeFromGroupUrn(String groupId) throws VootController.MalformedGroupUrnException {
        return (String)UrnUtils.getSchacHomeFromRegExp((Pattern)GROUP_PATTERN, (String)groupId).orElseThrow(() -> new VootController.MalformedGroupUrnException(groupId));
    }

    public static String getSchacHomeFromPersonUrn(String personId) throws VootController.MalformedPersonUrnException {
        return (String)UrnUtils.getSchacHomeFromRegExp((Pattern)PERSON_PATTERN, (String)personId).orElseThrow(() -> new VootController.MalformedPersonUrnException(personId));
    }

    public static boolean isFullyQualifiedGroupName(String groupId) {
        return GROUP_PATTERN.matcher(groupId).matches();
    }

    private static Optional<String> getIdFromRegExp(Pattern pattern, String id) {
        Matcher m = pattern.matcher(id);
        return m.matches() ? Optional.of(m.group(2)) : Optional.empty();
    }

    private static Optional<String> getSchacHomeFromRegExp(Pattern pattern, String id) {
        Matcher m = pattern.matcher(id);
        return m.matches() ? Optional.of(m.group(1)) : Optional.empty();
    }
}

