/*
 * Decompiled with CFR 0.152.
 */
package voot.oidc;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import voot.oauth.DecisionResourceServerTokenServices;
import voot.oidc.OidcSchacHomeAwareUserAuthenticationConverter;

public class OidcRemoteTokenServices
implements DecisionResourceServerTokenServices {
    private static Logger LOG = LoggerFactory.getLogger(OidcRemoteTokenServices.class);
    private String checkTokenEndpointUrl;
    private String clientId;
    private String clientSecret;
    private List<String> issuers;
    private AccessTokenConverter accessTokenConverter;
    private RestTemplate restTemplate;
    private HttpHeaders httpHeaders;

    public OidcRemoteTokenServices(String checkTokenEndpointUrl, String clientId, String clientSecret, String issuer, String schacHomeOrganizationKey) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.issuers = Stream.of(issuer.split(",")).map(String::trim).collect(Collectors.toList());
        this.restTemplate = new RestTemplate();
        this.accessTokenConverter = new DefaultAccessTokenConverter();
        ((DefaultAccessTokenConverter)this.accessTokenConverter).setUserTokenConverter((UserAuthenticationConverter)new OidcSchacHomeAwareUserAuthenticationConverter(schacHomeOrganizationKey, "client_id", "unspecified_id"));
        this.httpHeaders = this.headersForIntrospection();
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Object scope;
        Map map;
        try {
            map = this.introspection(accessToken);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED)) {
                throw new InvalidTokenException(accessToken);
            }
            throw e;
        }
        if (map.containsKey("error")) {
            LOG.warn("introspect returned error: " + map.get("error"));
            throw new InvalidTokenException(accessToken);
        }
        if (!map.containsKey("active") || !((Boolean)map.get("active")).booleanValue()) {
            LOG.warn("introspect returned inactive access_token: " + accessToken);
            throw new InvalidTokenException(accessToken);
        }
        Assert.state((boolean)map.containsKey("client_id"), (String)"Client id must be present in response from auth server");
        if (map.containsKey("scope") && (scope = map.get("scope")) instanceof String) {
            map.put("scope", Arrays.asList(((String)scope).split(" ")));
        }
        LOG.debug("Client {} has scopes {} for info {}", new Object[]{map.get("client_id"), map.get("scope"), map});
        return this.accessTokenConverter.extractAuthentication(map);
    }

    protected Map<String, Object> introspection(String accessToken) {
        String introspectUri = UriComponentsBuilder.fromHttpUrl((String)this.checkTokenEndpointUrl).queryParam("token", new Object[]{accessToken}).build().toUriString();
        HttpEntity entity = new HttpEntity((MultiValueMap)this.httpHeaders);
        return (Map)this.restTemplate.exchange(introspectUri, HttpMethod.GET, entity, Map.class, new Object[0]).getBody();
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        return new DefaultOAuth2AccessToken(accessToken);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected HttpHeaders headersForIntrospection() {
        HttpHeaders headers = new HttpHeaders();
        String basicAuthz = this.clientId + ":" + this.clientSecret;
        String authenticationCredentials = "Basic " + new String(Base64.encode((byte[])basicAuthz.getBytes(Charset.forName("UTF-8"))));
        headers.add("Authorization", authenticationCredentials);
        headers.add("Accept", "application/json");
        return headers;
    }

    public boolean canHandle(String accessToken) {
        return !this.isUUID(accessToken) && this.getIssuer(accessToken).map(iss -> this.issuers.contains(iss)).orElse(false) != false;
    }

    public String getCheckTokenEndpointUrl() {
        return this.checkTokenEndpointUrl;
    }

    public MultiValueMap<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

