/*
 * Decompiled with CFR 0.152.
 */
package voot.oidc;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import voot.oauth.ClientCredentialsAuthentication;
import voot.oauth.SchacHomeAuthentication;

public class OidcSchacHomeAwareUserAuthenticationConverter
extends DefaultUserAuthenticationConverter {
    private String schacHomeKey;
    private String clientIdKey;
    private String unspecifiedIdKey;
    private static final Set<GrantedAuthority> DEFAULT_AUTHORITIES = Collections.singleton(new SimpleGrantedAuthority("ROLE_USER"));

    public OidcSchacHomeAwareUserAuthenticationConverter(String schacHomeKey, String clientIdKey, String unspecifiedIdKey) {
        this.schacHomeKey = schacHomeKey;
        this.clientIdKey = clientIdKey;
        this.unspecifiedIdKey = unspecifiedIdKey;
    }

    public Authentication extractAuthentication(Map<String, ?> authenticationAttributes) {
        if (!authenticationAttributes.containsKey(this.unspecifiedIdKey) && authenticationAttributes.containsKey(this.clientIdKey)) {
            return new ClientCredentialsAuthentication((String)authenticationAttributes.get(this.clientIdKey), (Collection)DEFAULT_AUTHORITIES);
        }
        if (authenticationAttributes.containsKey(this.unspecifiedIdKey) && authenticationAttributes.containsKey(this.schacHomeKey)) {
            return new SchacHomeAuthentication((String)authenticationAttributes.get(this.schacHomeKey), authenticationAttributes.get(this.unspecifiedIdKey), (Object)"N/A", (Collection)DEFAULT_AUTHORITIES);
        }
        throw new InvalidClientException(String.format("Unsupported client authentication. Must contain either %s or %s and %s", this.clientIdKey, this.unspecifiedIdKey, this.schacHomeKey));
    }
}

