/*
 * Decompiled with CFR 0.152.
 */
package voot;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.trace.http.HttpTraceEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import voot.ExternalGroupsService;
import voot.VootServiceApplication;
import voot.provider.EduIDGuestProvider;
import voot.provider.GroupProviderType;
import voot.provider.OpenSocialClient;
import voot.provider.OpenSocialMembersClient;
import voot.provider.Provider;
import voot.provider.TeamsProviderClient;
import voot.provider.Voot2Provider;

@SpringBootApplication(exclude={HttpTraceEndpointAutoConfiguration.class, MetricsAutoConfiguration.class})
public class VootServiceApplication {
    @Value(value="${support.linkedGrouperExternalGroups}")
    private boolean supportLinkedGrouperExternalGroups;

    public static void main(String[] args) {
        SpringApplication.run(VootServiceApplication.class, (String[])args);
    }

    @Bean
    @Autowired
    public ExternalGroupsService externalGroupsService(@Value(value="${externalProviders.config.path}") Resource configResource) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map config = (Map)yaml.load(configResource.getInputStream());
        List externalGroupProviders = (List)config.get("externalGroupProviders");
        List groupClients = externalGroupProviders.stream().map(entryMap -> {
            String type = (String)entryMap.get("type");
            String url = StringUtils.trimTrailingCharacter((String)((String)entryMap.get("url")), (char)'/');
            String schacHomeOrganization = (String)entryMap.get("schacHomeOrganization");
            String name = (String)entryMap.get("name");
            Integer timeoutMillis = (Integer)entryMap.get("timeoutMillis");
            Map rawCredentials = (Map)entryMap.get("credentials");
            String username = (String)rawCredentials.get("username");
            String secret = (String)rawCredentials.get("secret");
            GroupProviderType groupProviderType = GroupProviderType.valueOf((String)type.toUpperCase());
            Provider.Configuration configuration = new Provider.Configuration(groupProviderType, url, new Provider.Configuration.Credentials(username, secret), timeoutMillis, schacHomeOrganization, name);
            switch (1.$SwitchMap$voot$provider$GroupProviderType[groupProviderType.ordinal()]) {
                case 1: {
                    return new Voot2Provider(configuration);
                }
                case 2: {
                    return new OpenSocialClient(configuration);
                }
                case 3: {
                    return new TeamsProviderClient(configuration);
                }
                case 4: {
                    return new OpenSocialMembersClient(configuration);
                }
                case 5: {
                    return new EduIDGuestProvider(configuration);
                }
            }
            throw new IllegalArgumentException("Unknown external provider-type: " + type);
        }).collect(Collectors.toList());
        return new ExternalGroupsService(groupClients, this.supportLinkedGrouperExternalGroups);
    }
}

