/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import voot.model.Group;
import voot.model.Member;
import voot.model.Membership;
import voot.provider.AbstractProvider;
import voot.provider.Provider;

public class EduIDGuestProvider
extends AbstractProvider {
    private final String groupMembershipsUrlTemplate;

    public EduIDGuestProvider(Provider.Configuration configuration) {
        super(configuration);
        this.groupMembershipsUrlTemplate = "%s/api/voot/%s";
    }

    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return true;
    }

    public List<Group> getGroupMemberships(String uid) {
        RequestEntity requestEntity = new RequestEntity(HttpMethod.GET, URI.create(String.format(this.groupMembershipsUrlTemplate, this.configuration.url, uid)));
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return ((List)responseEntity.getBody()).stream().map(arg_0 -> this.parseGroup(arg_0)).collect(Collectors.toList());
    }

    private Group parseGroup(Map<String, String> map) {
        String name = map.get("name");
        return new Group(map.get("urn"), name, name, "eduID", Membership.MEMBER);
    }

    public List<Group> getAllGroups() {
        return Collections.emptyList();
    }

    public Optional<Group> getGroupMembership(String uid, String groupId) {
        return Optional.empty();
    }

    public List<Member> getMembers(String groupId) {
        return Collections.emptyList();
    }

    public List<Member> getMembers(String personId, String groupId) {
        return Collections.emptyList();
    }
}

