/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;
import voot.model.Group;
import voot.model.Member;
import voot.provider.Provider;
import voot.provider.TeamsProvider;
import voot.provider.Voot2Provider;
import voot.util.UrnUtils;

public class TeamsProviderClient
extends Voot2Provider
implements TeamsProvider {
    public TeamsProviderClient(Provider.Configuration configuration) {
        super(configuration);
    }

    public boolean isTeamsGroup(String groupId) {
        Matcher matcher = UrnUtils.GROUP_PATTERN.matcher(groupId);
        return matcher.matches() && matcher.group(1).equals(this.configuration.schacHomeOrganization);
    }

    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return true;
    }

    public Optional<Group> findByLocalGroupId(String localGroupId) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)String.format("%s/group/%s", this.configuration.url, localGroupId)).build().encode().toUri();
        ResponseEntity response = this.restTemplate.getForEntity(uri, String.class);
        return (Optional)this.handleResponse(response, arg_0 -> ((TeamsProviderClient)this).parseSingleGroup(arg_0), "findByLocalGroupId", Optional.empty());
    }

    public List<Group> linkedLocalTeamsGroup(Collection<String> fullyQualifiedExternalGroupIds) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)String.format("%s/linked-locals", this.configuration.url)).queryParam("externalGroupIds", new Object[]{String.join((CharSequence)",", fullyQualifiedExternalGroupIds)}).build().encode().toUri();
        ResponseEntity response = this.restTemplate.getForEntity(uri, String.class);
        return (List)this.handleResponse(response, arg_0 -> ((TeamsProviderClient)this).parseGroups(arg_0), "findByLocalGroupId", Collections.emptyList());
    }

    public List<String> linkedExternalGroupIds(String localGroupId) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)String.format("%s/linked-externals", this.configuration.url)).queryParam("teamId", new Object[]{localGroupId}).build().encode().toUri();
        ResponseEntity response = this.restTemplate.getForEntity(uri, List.class);
        return (List)this.handleResponse(response, s -> s, "findByLocalGroupId", Collections.emptyList());
    }

    public List<Member> getMembers(String personId, String groupId) {
        return this.getMembers(groupId);
    }

    public List<Member> getMembers(String groupId) {
        String uri = String.format("%s/members/{groupId}", this.configuration.url);
        ResponseEntity response = this.restTemplate.getForEntity(uri, String.class, new Object[]{groupId});
        return (List)this.handleResponse(response, arg_0 -> this.parseMembers(arg_0), "getMembers", Collections.emptyList());
    }

    public List<Group> getAllGroups() {
        String uri = String.format("%s/groups", this.configuration.url);
        ResponseEntity response = this.restTemplate.getForEntity(uri, String.class, new Object[0]);
        return (List)this.handleResponse(response, arg_0 -> ((TeamsProviderClient)this).parseGroups(arg_0), "getAllGroups", Collections.emptyList());
    }

    protected String personUrnFromFullyQualifiedUrn(String uid) {
        return uid;
    }

    private List<Member> parseMembers(String response) {
        List maps = (List)this.parseJson(response, List.class);
        return maps.stream().map(map -> new Member((String)map.get("id"), (String)map.get("name"), (String)map.get("email"))).collect(Collectors.toList());
    }
}

