/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import voot.model.Group;
import voot.model.Membership;
import voot.provider.Provider;
import voot.provider.Voot2Provider;

public class OpenSocialClient
extends Voot2Provider {
    public OpenSocialClient(Provider.Configuration configuration) {
        super(configuration);
        this.allMembershipsUrlTemplate = "%s/groups/{uid}";
        this.specificMembershipTemplate = "%s/groups/{uid}/{groupId}";
    }

    protected Set<Group> parseGroups(String response) {
        List groups = (List)((Map)this.parseJson(response, Map.class)).get("entry");
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return Collections.emptySet();
        }
        return groups.stream().map(map -> {
            Object idHolder = map.get("id");
            String id = this.groupIdPrefix + (idHolder instanceof Map ? ((Map)idHolder).get("groupId") : idHolder);
            return new Group(id, (String)map.get("title"), (String)map.get("description"), this.configuration.name, new Membership(map.getOrDefault("voot_membership_role", "member")));
        }).collect(Collectors.toSet());
    }

    protected Optional<Group> parseSingleGroup(String response) {
        Set groups = this.parseGroups(response);
        return groups.isEmpty() ? Optional.empty() : Optional.of((Group)groups.iterator().next());
    }
}

