/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import voot.model.Group;
import voot.model.Member;
import voot.model.Membership;
import voot.provider.AbstractProvider;
import voot.provider.Provider;

public class InviteProvider
extends AbstractProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InviteProvider.class);
    private final String groupMembershipsUrlTemplate;

    public InviteProvider(Provider.Configuration configuration) {
        super(configuration);
        this.groupMembershipsUrlTemplate = "%s/api/voot/%s";
    }

    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return true;
    }

    public boolean isExternalGroupProvider() {
        return false;
    }

    public Set<Group> getGroupMemberships(String uid) {
        LOG.debug("Calling getGroupMemberships for " + uid);
        String uri = String.format(this.groupMembershipsUrlTemplate, this.configuration.url, uid);
        RequestEntity requestEntity = new RequestEntity(HttpMethod.GET, URI.create(uri));
        return ((List)this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody()).stream().map(arg_0 -> this.parseGroup(arg_0)).collect(Collectors.toSet());
    }

    private Group parseGroup(Map<String, String> map) {
        String name = map.get("name");
        return new Group(map.get("urn"), name, name, "Invite", Membership.MEMBER);
    }

    public Set<Group> getAllGroups() {
        return Collections.emptySet();
    }

    public Optional<Group> getGroupMembership(String uid, String groupId) {
        return Optional.empty();
    }

    public Set<Member> getMembers(String groupId) {
        return Collections.emptySet();
    }

    public Set<Member> getMembers(String personId, String groupId) {
        return Collections.emptySet();
    }
}

