/*
 * Decompiled with CFR 0.152.
 */
package voot.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import voot.model.Group;
import voot.model.Member;
import voot.model.Membership;
import voot.provider.AbstractProvider;
import voot.provider.Provider;
import voot.util.UrnUtils;

public class Voot2Provider
extends AbstractProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(Voot2Provider.class);
    protected String allMembershipsUrlTemplate = "%s/user/{uid}/groups";
    protected String specificMembershipTemplate = "%s/user/{uid}/groups/{groupId}";

    public Voot2Provider(Provider.Configuration configuration) {
        super(configuration);
    }

    public boolean shouldBeQueriedForMemberships(String schacHomeOrganization) {
        return this.configuration.schacHomeOrganization.equalsIgnoreCase(schacHomeOrganization);
    }

    public Set<Group> getGroupMemberships(String uid) {
        LOG.debug("Querying getGroupMemberships for subjectId: {} and name: {}", (Object)uid, (Object)this.configuration.schacHomeOrganization);
        String localUid = this.personUrnFromFullyQualifiedUrn(uid);
        ResponseEntity response = this.restTemplate.getForEntity(String.format(this.allMembershipsUrlTemplate, this.configuration.url), String.class, new Object[]{localUid});
        return (Set)this.handleResponse(response, arg_0 -> this.parseGroups(arg_0), "getGroupMemberships", Collections.emptySet());
    }

    public Set<Group> getAllGroups() {
        return Collections.emptySet();
    }

    public Optional<Group> getGroupMembership(String uid, String groupId) {
        LOG.debug("Querying getGroupMembership for subjectId: {} and name: {}", (Object)uid, (Object)this.configuration.schacHomeOrganization);
        String localUid = this.personUrnFromFullyQualifiedUrn(uid);
        String localGroupId = UrnUtils.extractLocalGroupId((String)groupId);
        String url = String.format(this.specificMembershipTemplate, this.configuration.url);
        LOG.debug("Invoking {} on provider {}", (Object)url, (Object)this);
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[]{localUid, localGroupId});
        return (Optional)this.handleResponse(response, arg_0 -> this.parseSingleGroup(arg_0), "getGroupMembership", Optional.empty());
    }

    protected String personUrnFromFullyQualifiedUrn(String uid) {
        return UrnUtils.extractLocalUid((String)uid);
    }

    public Set<Member> getMembers(String groupId) {
        throw new IllegalArgumentException("Voot2Providers do not support getting members");
    }

    public Set<Member> getMembers(String personId, String groupId) {
        return this.getMembers(groupId);
    }

    protected Set<Group> parseGroups(String response) {
        List maps = (List)this.parseJson(response, List.class);
        return maps.stream().map(arg_0 -> this.parseGroup(arg_0)).collect(Collectors.toSet());
    }

    protected Optional<Group> parseSingleGroup(String response) {
        return Optional.of(this.parseGroup((Map)this.parseJson(response, Map.class)));
    }

    private Group parseGroup(Map<String, Object> item) {
        return new Group(this.groupIdPrefix + item.get("id"), (String)item.get("displayName"), (String)item.get("description"), this.configuration.name, this.parseMembership(item.get("membership")));
    }

    private Membership parseMembership(Object membership) {
        if (membership instanceof String) {
            return new Membership((String)String.class.cast(membership));
        }
        if (membership instanceof Map) {
            return new Membership((String)String.class.cast(((Map)Map.class.cast(membership)).get("basic")));
        }
        return Membership.MEMBER;
    }
}

