/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.response;

import java.util.List;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.response.CustomResponseTypesHandler;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;

public class CompositeCustomResponseTypesHandler
implements CustomResponseTypesHandler {
    private final List<CustomResponseTypesHandler> customResponseTypesHandlers;

    public CompositeCustomResponseTypesHandler(List<CustomResponseTypesHandler> customResponseTypesHandlers) {
        Assert.notNull(customResponseTypesHandlers, (String)"customResponseTypesHandlers is null");
        this.customResponseTypesHandlers = customResponseTypesHandlers;
    }

    @Override
    public boolean canHandleResponseTypes(Set<String> responseTypes) {
        for (CustomResponseTypesHandler handler : this.customResponseTypesHandlers) {
            boolean canHandle = handler.canHandleResponseTypes(responseTypes);
            if (!canHandle) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelAndView handleApprovedAuthorizationRequest(AuthorizationRequest authorizationRequest, Authentication authentication) {
        for (CustomResponseTypesHandler handler : this.customResponseTypesHandlers) {
            boolean canHandle = handler.canHandleResponseTypes(authorizationRequest.getResponseTypes());
            if (!canHandle) continue;
            return handler.handleApprovedAuthorizationRequest(authorizationRequest, authentication);
        }
        throw new UnsupportedResponseTypeException("No custom response types are supported. Unsupported response types: " + authorizationRequest.getResponseTypes());
    }
}

