/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.response;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.response.AuthorizationRequestViewResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultAuthorizationRequestViewResolver
implements AuthorizationRequestViewResolver {
    @Override
    public View getSuccessfulAuthorizationCodeView(AuthorizationRequest authorizationRequest, String authorizationCode) {
        if (authorizationCode == null) {
            throw new IllegalStateException("No authorization code found in the current request scope.");
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("code", authorizationCode);
        String state = authorizationRequest.getState();
        if (state != null) {
            query.put("state", state);
        }
        return new RedirectView(this.append(authorizationRequest.getRedirectUri(), query, false), false, true, false);
    }

    @Override
    public View getSuccessfulImplicitGrantView(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken) {
        return new RedirectView(this.appendAccessToken(authorizationRequest, accessToken), false, true, false);
    }

    @Override
    public View getUnsuccessfulView(AuthorizationRequest authorizationRequest, OAuth2Exception failure) {
        if (authorizationRequest == null || authorizationRequest.getRedirectUri() == null) {
            throw new UnapprovedClientAuthenticationException("Authorization failure, and no redirect URI.", failure);
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("error", failure.getOAuth2ErrorCode());
        query.put("error_description", failure.getMessage());
        if (authorizationRequest.getState() != null) {
            query.put("state", authorizationRequest.getState());
        }
        if (failure.getAdditionalInformation() != null) {
            for (Map.Entry<String, String> additionalInfo : failure.getAdditionalInformation().entrySet()) {
                query.put(additionalInfo.getKey(), additionalInfo.getValue());
            }
        }
        String url = this.append(authorizationRequest.getRedirectUri(), query, this.appendToFragment(authorizationRequest));
        return new RedirectView(url, false, true, false);
    }

    protected boolean appendToFragment(AuthorizationRequest authorizationRequest) {
        return authorizationRequest.getResponseTypes().contains("token");
    }

    private String append(String base, Map<String, ?> query, boolean fragment) {
        return this.append(base, query, null, fragment);
    }

    private String append(String base, Map<String, ?> query, Map<String, String> keys, boolean fragment) {
        URI redirectUri;
        UriComponentsBuilder template = UriComponentsBuilder.newInstance();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)base);
        try {
            redirectUri = builder.build(true).toUri();
        }
        catch (Exception e) {
            redirectUri = builder.build().toUri();
            builder = UriComponentsBuilder.fromUri((URI)redirectUri);
        }
        template.scheme(redirectUri.getScheme()).port(redirectUri.getPort()).host(redirectUri.getHost()).userInfo(redirectUri.getUserInfo()).path(redirectUri.getPath());
        if (fragment) {
            StringBuilder values = new StringBuilder();
            if (redirectUri.getFragment() != null) {
                String append = redirectUri.getFragment();
                values.append(append);
            }
            for (String key : query.keySet()) {
                if (values.length() > 0) {
                    values.append("&");
                }
                String name = key;
                if (keys != null && keys.containsKey(key)) {
                    name = keys.get(key);
                }
                values.append(name + "={" + key + "}");
            }
            if (values.length() > 0) {
                template.fragment(values.toString());
            }
            UriComponents encoded = template.build().expand(query).encode();
            builder.fragment(encoded.getFragment());
        } else {
            Iterator<String> values = query.keySet().iterator();
            while (values.hasNext()) {
                String key;
                String name = key = values.next();
                if (keys != null && keys.containsKey(key)) {
                    name = keys.get(key);
                }
                template.queryParam(name, new Object[]{"{" + key + "}"});
            }
            template.fragment(redirectUri.getFragment());
            UriComponents encoded = template.build().expand(query).encode();
            builder.query(encoded.getQuery());
        }
        return builder.build().toUriString();
    }

    private String appendAccessToken(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken) {
        String originalScope;
        Date expiration;
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        HashMap<String, String> keys = new HashMap<String, String>();
        if (accessToken == null) {
            throw new InvalidRequestException("An implicit grant could not be made");
        }
        vars.put("access_token", accessToken.getValue());
        vars.put("token_type", accessToken.getTokenType());
        String state = authorizationRequest.getState();
        if (state != null) {
            vars.put("state", state);
        }
        if ((expiration = accessToken.getExpiration()) != null) {
            long expires_in = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
            vars.put("expires_in", expires_in);
        }
        if ((originalScope = (String)authorizationRequest.getRequestParameters().get("scope")) == null || !OAuth2Utils.parseParameterList(originalScope).equals(accessToken.getScope())) {
            vars.put("scope", OAuth2Utils.formatParameterList(accessToken.getScope()));
        }
        Map<String, Object> additionalInformation = accessToken.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            Object value = additionalInformation.get(key);
            if (value == null) continue;
            keys.put("extra_" + key, key);
            vars.put("extra_" + key, value);
        }
        return this.append(authorizationRequest.getRedirectUri(), vars, keys, true);
    }
}

