/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import java.util.Map;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinitionSource;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.JwtHeaderConverter;

class JwkVerifyingJwtAccessTokenConverter
extends JwtAccessTokenConverter {
    private final JwkDefinitionSource jwkDefinitionSource;
    private final JwtHeaderConverter jwtHeaderConverter = new JwtHeaderConverter();
    private final JsonParser jsonParser = JsonParserFactory.create();

    JwkVerifyingJwtAccessTokenConverter(JwkDefinitionSource jwkDefinitionSource) {
        this.jwkDefinitionSource = jwkDefinitionSource;
    }

    @Override
    protected Map<String, Object> decode(String token) {
        Map<String, String> headers = this.jwtHeaderConverter.convert(token);
        String keyIdHeader = headers.get("kid");
        if (keyIdHeader == null) {
            throw new InvalidTokenException("Invalid JWT/JWS: kid is a required JOSE Header");
        }
        JwkDefinition jwkDefinition = this.jwkDefinitionSource.getDefinitionLoadIfNecessary(keyIdHeader);
        if (jwkDefinition == null) {
            throw new InvalidTokenException("Invalid JOSE Header kid (" + keyIdHeader + ")");
        }
        String algorithmHeader = headers.get("alg");
        if (algorithmHeader == null) {
            throw new InvalidTokenException("Invalid JWT/JWS: alg is a required JOSE Header");
        }
        if (!algorithmHeader.equals(jwkDefinition.getAlgorithm().headerParamValue())) {
            throw new InvalidTokenException("Invalid JOSE Header alg (" + algorithmHeader + ") does not match algorithm associated to JWK with " + "kid" + " (" + keyIdHeader + ")");
        }
        SignatureVerifier verifier = this.jwkDefinitionSource.getVerifier(keyIdHeader);
        Jwt jwt = JwtHelper.decode((String)token);
        jwt.verifySignature(verifier);
        Map<String, Object> claims = this.jsonParser.parseMap(jwt.getClaims());
        if (claims.containsKey("exp") && claims.get("exp") instanceof Integer) {
            Integer expiryInt = (Integer)claims.get("exp");
            claims.put("exp", new Long(expiryInt.intValue()));
        }
        return claims;
    }

    @Override
    protected String encode(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        throw new JwkException("JWT signing (JWS) is not supported.");
    }
}

