/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.response;

import java.util.List;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.response.ResponseTypesHandler;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;

public class CompositeResponseTypesHandler
implements ResponseTypesHandler {
    private final List<ResponseTypesHandler> responseTypesHandlers;

    public CompositeResponseTypesHandler(List<ResponseTypesHandler> responseTypesHandlers) {
        Assert.notNull(responseTypesHandlers, (String)"responseTypesHandlers is null");
        this.responseTypesHandlers = responseTypesHandlers;
    }

    @Override
    public boolean canHandleResponseTypes(Set<String> responseTypes) {
        for (ResponseTypesHandler handler : this.responseTypesHandlers) {
            boolean canHandle = handler.canHandleResponseTypes(responseTypes);
            if (!canHandle) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelAndView handleApprovedAuthorizationRequest(Set<String> responseTypes, AuthorizationRequest authorizationRequest, Authentication authentication, AuthorizationCodeServices authorizationCodeServices) {
        for (ResponseTypesHandler handler : this.responseTypesHandlers) {
            boolean canHandle = handler.canHandleResponseTypes(responseTypes);
            if (!canHandle) continue;
            return handler.handleApprovedAuthorizationRequest(responseTypes, authorizationRequest, authentication, authorizationCodeServices);
        }
        throw new UnsupportedResponseTypeException("Unsupported response types: " + authorizationRequest.getResponseTypes());
    }
}

