/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.response;

import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenRequest;
import org.springframework.security.oauth2.provider.response.AuthorizationRequestViewResolver;
import org.springframework.security.oauth2.provider.response.DefaultAuthorizationRequestViewResolver;
import org.springframework.security.oauth2.provider.response.ResponseTypesHandler;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class DefaultResponseTypesHandler
implements ResponseTypesHandler {
    private Object implicitLock = new Object();
    private AuthorizationRequestViewResolver authorizationRequestViewResolver = new DefaultAuthorizationRequestViewResolver();
    private TokenGranter tokenGranter;
    private OAuth2RequestFactory oAuth2RequestFactory;

    public DefaultResponseTypesHandler(TokenGranter tokenGranter, OAuth2RequestFactory oAuth2RequestFactory) {
        Assert.state((tokenGranter != null ? 1 : 0) != 0, (String)"TokenGranter must be provided");
        Assert.state((oAuth2RequestFactory != null ? 1 : 0) != 0, (String)"OAuth2RequestFactory must be provided");
        this.tokenGranter = tokenGranter;
        this.oAuth2RequestFactory = oAuth2RequestFactory;
    }

    @Override
    public boolean canHandleResponseTypes(Set<String> responseTypes) {
        return responseTypes.contains("token") || responseTypes.contains("code");
    }

    @Override
    public ModelAndView handleApprovedAuthorizationRequest(Set<String> responseTypes, AuthorizationRequest authorizationRequest, Authentication authentication, AuthorizationCodeServices authorizationCodeServices) throws OAuth2Exception {
        try {
            if (responseTypes.contains("token")) {
                return this.getImplicitGrantResponse(authorizationRequest);
            }
            if (responseTypes.contains("code")) {
                return new ModelAndView(this.getAuthorizationCodeResponse(authorizationRequest, authentication, authorizationCodeServices));
            }
            return this.handleUnsupportedResponseType(responseTypes, authorizationRequest, authentication);
        }
        catch (OAuth2Exception e) {
            View redirect = this.authorizationRequestViewResolver.getUnsuccessfulView(authorizationRequest, e);
            return new ModelAndView(redirect);
        }
    }

    protected ModelAndView handleUnsupportedResponseType(Set<String> responseTypes, AuthorizationRequest authorizationRequest, Authentication authentication) {
        throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
    }

    private ModelAndView getImplicitGrantResponse(AuthorizationRequest authorizationRequest) throws OAuth2Exception {
        OAuth2AccessToken accessToken = this.getOAuth2AccessToken(authorizationRequest);
        if (accessToken == null) {
            throw new UnsupportedResponseTypeException("Unsupported response type: token");
        }
        View view = this.authorizationRequestViewResolver.getSuccessfulImplicitGrantView(authorizationRequest, accessToken);
        return new ModelAndView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OAuth2AccessToken getOAuth2AccessToken(AuthorizationRequest authorizationRequest) {
        TokenRequest tokenRequest = this.oAuth2RequestFactory.createTokenRequest(authorizationRequest, "implicit");
        OAuth2Request storedOAuth2Request = this.oAuth2RequestFactory.createOAuth2Request(authorizationRequest);
        OAuth2AccessToken accessToken = null;
        Object object = this.implicitLock;
        synchronized (object) {
            accessToken = this.tokenGranter.grant("implicit", new ImplicitTokenRequest(tokenRequest, storedOAuth2Request));
        }
        return accessToken;
    }

    private View getAuthorizationCodeResponse(AuthorizationRequest authorizationRequest, Authentication authUser, AuthorizationCodeServices authorizationCodeServices) {
        try {
            OAuth2Request storedOAuth2Request = this.oAuth2RequestFactory.createOAuth2Request(authorizationRequest);
            OAuth2Authentication combinedAuth = new OAuth2Authentication(storedOAuth2Request, authUser);
            String authorizationCode = authorizationCodeServices.createAuthorizationCode(combinedAuth);
            return this.authorizationRequestViewResolver.getSuccessfulAuthorizationCodeView(authorizationRequest, authorizationCode);
        }
        catch (OAuth2Exception e) {
            if (authorizationRequest.getState() != null) {
                e.addAdditionalInformation("state", authorizationRequest.getState());
            }
            throw e;
        }
    }

    public void setTokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
    }

    public void setOAuth2RequestFactory(OAuth2RequestFactory oAuth2RequestFactory) {
        this.oAuth2RequestFactory = oAuth2RequestFactory;
    }

    public void setAuthorizationRequestViewResolver(AuthorizationRequestViewResolver authorizationRequestViewResolver) {
        this.authorizationRequestViewResolver = authorizationRequestViewResolver;
    }
}

