/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;
import org.springframework.security.oauth2.provider.response.AuthorizationRequestViewResolver;
import org.springframework.security.oauth2.provider.response.DefaultAuthorizationRequestViewResolver;
import org.springframework.security.oauth2.provider.response.ResponseTypesHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@FrameworkEndpoint
@SessionAttributes(value={"authorizationRequest"})
public class AuthorizationEndpoint
extends AbstractEndpoint {
    private AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    private RedirectResolver redirectResolver = new DefaultRedirectResolver();
    private UserApprovalHandler userApprovalHandler = new DefaultUserApprovalHandler();
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private OAuth2RequestValidator oauth2RequestValidator = new DefaultOAuth2RequestValidator();
    private AuthorizationRequestViewResolver authorizationRequestViewResolver = new DefaultAuthorizationRequestViewResolver();
    private ResponseTypesHandler responseTypesHandler;
    private String userApprovalPage = "forward:/oauth/confirm_access";
    private String errorPage = "forward:/oauth/error";

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.responseTypesHandler != null ? 1 : 0) != 0, (String)"ResponseTypesHandler must be provided");
    }

    @RequestMapping(value={"/oauth/authorize"})
    public ModelAndView authorize(Map<String, Object> model, @RequestParam Map<String, String> parameters, SessionStatus sessionStatus, Principal principal) {
        AuthorizationRequest authorizationRequest = this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        Set<String> responseTypes = authorizationRequest.getResponseTypes();
        if (!this.responseTypesHandler.canHandleResponseTypes(responseTypes)) {
            throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
        }
        if (authorizationRequest.getClientId() == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        try {
            if (!(principal instanceof Authentication) || !((Authentication)principal).isAuthenticated()) {
                throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorization can be completed.");
            }
            Authentication authentication = (Authentication)principal;
            ClientDetails client = this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId());
            String redirectUriParameter = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            String resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUriParameter, client);
            if (!StringUtils.hasText((String)resolvedRedirect)) {
                throw new RedirectMismatchException("A redirectUri must be either supplied or preconfigured in the ClientDetails");
            }
            authorizationRequest.setRedirectUri(resolvedRedirect);
            this.oauth2RequestValidator.validateScope(authorizationRequest, client);
            authorizationRequest = this.userApprovalHandler.checkForPreApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, authentication);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.isApproved()) {
                return this.responseTypesHandler.handleApprovedAuthorizationRequest(responseTypes, authorizationRequest, authentication, this.authorizationCodeServices);
            }
            model.put("authorizationRequest", authorizationRequest);
            return this.getUserApprovalPageResponse(model, authorizationRequest, authentication);
        }
        catch (RuntimeException e) {
            sessionStatus.setComplete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/oauth/authorize"}, method={RequestMethod.POST}, params={"user_oauth_approval"})
    public View approveOrDeny(@RequestParam Map<String, String> approvalParameters, Map<String, ?> model, SessionStatus sessionStatus, Principal principal) {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorizing an access token.");
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        if (authorizationRequest == null) {
            sessionStatus.setComplete();
            throw new InvalidRequestException("Cannot approve uninitialized authorization request.");
        }
        try {
            Set<String> responseTypes = authorizationRequest.getResponseTypes();
            if (!this.responseTypesHandler.canHandleResponseTypes(responseTypes)) {
                throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
            }
            authorizationRequest.setApprovalParameters(approvalParameters);
            authorizationRequest = this.userApprovalHandler.updateAfterApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.getRedirectUri() == null) {
                sessionStatus.setComplete();
                throw new InvalidRequestException("Cannot approve request when no redirect URI is provided.");
            }
            if (!authorizationRequest.isApproved()) {
                View view = this.authorizationRequestViewResolver.getUnsuccessfulView(authorizationRequest, new UserDeniedAuthorizationException("User denied access"));
                return view;
            }
            View view = this.responseTypesHandler.handleApprovedAuthorizationRequest(responseTypes, authorizationRequest, (Authentication)principal, this.authorizationCodeServices).getView();
            return view;
        }
        finally {
            sessionStatus.setComplete();
        }
    }

    private ModelAndView getUserApprovalPageResponse(Map<String, Object> model, AuthorizationRequest authorizationRequest, Authentication principal) {
        this.logger.debug((Object)("Loading user approval page: " + this.userApprovalPage));
        model.putAll(this.userApprovalHandler.getUserApprovalRequest(authorizationRequest, principal));
        return new ModelAndView(this.userApprovalPage, model);
    }

    public void setUserApprovalPage(String userApprovalPage) {
        this.userApprovalPage = userApprovalPage;
    }

    public void setAuthorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    public void setOAuth2RequestValidator(OAuth2RequestValidator oauth2RequestValidator) {
        this.oauth2RequestValidator = oauth2RequestValidator;
    }

    public void setResponseTypesHandler(ResponseTypesHandler responseTypesHandler) {
        this.responseTypesHandler = responseTypesHandler;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setAuthorizationRequestViewResolver(AuthorizationRequestViewResolver authorizationRequestViewResolver) {
        this.authorizationRequestViewResolver = authorizationRequestViewResolver;
    }

    public void setImplicitGrantService(ImplicitGrantService implicitGrantService) {
    }

    @ExceptionHandler(value={ClientRegistrationException.class})
    public ModelAndView handleClientRegistrationException(Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling ClientRegistrationException error: " + e.getMessage()));
        return this.handleException(new BadClientCredentialsException(), webRequest);
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public ModelAndView handleOAuth2Exception(OAuth2Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling OAuth2 error: " + e.getSummary()));
        return this.handleException(e, webRequest);
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public ModelAndView handleHttpSessionRequiredException(HttpSessionRequiredException e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling Session required error: " + e.getMessage()));
        return this.handleException((Exception)new AccessDeniedException("Could not obtain authorization request from session", (Throwable)e), webRequest);
    }

    private ModelAndView handleException(Exception e, ServletWebRequest webRequest) throws Exception {
        ResponseEntity<OAuth2Exception> translate = this.getExceptionTranslator().translate(e);
        webRequest.getResponse().setStatus(translate.getStatusCode().value());
        if (e instanceof ClientAuthenticationException || e instanceof RedirectMismatchException) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
        AuthorizationRequest authorizationRequest = null;
        try {
            authorizationRequest = this.getAuthorizationRequestForError(webRequest);
            String requestedRedirectParam = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            String requestedRedirect = this.redirectResolver.resolveRedirect(requestedRedirectParam, this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId()));
            authorizationRequest.setRedirectUri(requestedRedirect);
            View view = this.authorizationRequestViewResolver.getUnsuccessfulView(authorizationRequest, (OAuth2Exception)translate.getBody());
            return new ModelAndView(view);
        }
        catch (OAuth2Exception ex) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
    }

    private AuthorizationRequest getAuthorizationRequestForError(ServletWebRequest webRequest) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.sessionAttributeStore.retrieveAttribute((WebRequest)webRequest, "authorizationRequest");
        if (authorizationRequest != null) {
            return authorizationRequest;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map map = webRequest.getParameterMap();
        for (String key : map.keySet()) {
            String[] values = (String[])map.get(key);
            if (values == null || values.length <= 0) continue;
            parameters.put(key, values[0]);
        }
        try {
            return this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
        catch (Exception e) {
            return this.getDefaultOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
    }
}

