/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nl.surfnet.coin.api.client.domain.AbstractEntry;
import nl.surfnet.coin.api.client.domain.Group20;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Group20Entry
extends AbstractEntry {
    @JsonIgnore
    public static List<String> SORT_ATR = Arrays.asList("id", "title", "description");
    @JsonIgnore
    public static Comparator NULL_SAFE_STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return (o1 == null ? "" : o1.toLowerCase()).compareTo(o2 == null ? "" : o2.toLowerCase());
        }
    };
    private List<Group20> entry;

    public Group20Entry(List<Group20> groups) {
        this.entry = groups;
    }

    public Group20Entry() {
    }

    public Group20Entry(List<Group20> groups, int pageSize, int offset, String sortBy, int rowCount) {
        this.entry = groups;
        this.setFiltered(true);
        this.setItemsPerPage(pageSize);
        this.setSorted(true);
        this.setStartIndex(offset);
        this.setUpdatedSince(false);
        this.setTotalResults(rowCount);
    }

    public List<Group20> getEntry() {
        return this.entry;
    }

    public void setEntry(List<Group20> entry) {
        this.entry = entry;
    }

    @Override
    public int getEntrySize() {
        return this.entry != null ? this.entry.size() : 0;
    }

    @Override
    @JsonIgnore
    public List getEntryCollection() {
        return this.entry;
    }

    @Override
    @JsonIgnore
    public void sortEntryCollection(String sort) {
        if (StringUtils.isNotBlank((String)sort) && SORT_ATR.contains(sort)) {
            BeanComparator beanComparator = new BeanComparator(sort, NULL_SAFE_STRING_COMPARATOR);
            Collections.sort(this.entry, beanComparator);
        }
    }

    @Override
    @JsonIgnore
    public void setEntryCollection(List entry) {
        this.entry = entry;
    }
}

