/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.coin.api.client.OAuthEnvironment;
import nl.surfnet.coin.api.client.OAuthProtocol;
import nl.surfnet.coin.api.client.OAuthRepository;
import nl.surfnet.coin.api.client.OAuthToken;
import nl.surfnet.coin.api.client.OAuthVersion;
import nl.surfnet.coin.api.client.OpenConextApi10aThreeLegged;
import nl.surfnet.coin.api.client.OpenConextApi10aTwoLegged;
import nl.surfnet.coin.api.client.OpenConextApi20AuthorizationCode;
import nl.surfnet.coin.api.client.OpenConextJsonParser;
import nl.surfnet.coin.api.client.OpenConextOAuthClient;
import nl.surfnet.coin.api.client.domain.Group;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Person;
import org.apache.commons.io.IOUtils;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OpenConextOAuthClientImpl
implements OpenConextOAuthClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConextOAuthClientImpl.class);
    private static final String REQUEST_TOKEN = "REQUEST_TOKEN";
    private OAuthEnvironment environment;
    private OAuthRepository repository;
    private OpenConextJsonParser parser = new OpenConextJsonParser();

    public OpenConextOAuthClientImpl(OAuthEnvironment environment, OAuthRepository repository) {
        this.environment = environment;
        this.repository = repository;
    }

    @Override
    public boolean isAccessTokenGranted(String userId) {
        return this.repository.getToken(userId) != null;
    }

    @Override
    public void redirectToAuthorizationUrl(OAuthVersion version, HttpServletRequest request, HttpServletResponse response) {
        String authUrl = this.doGetAuthorizationUrl(version, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting to authorization URL: {}", (Object)authUrl);
        }
        try {
            response.sendRedirect(authUrl);
        }
        catch (IOException e) {
            throw new RuntimeException("IOexception occured when redirecting to :" + authUrl, e);
        }
    }

    private String doGetAuthorizationUrl(OAuthVersion version, HttpServletRequest request) {
        Token requestToken;
        OAuthService service = this.getService(version, OAuthProtocol.threelegged);
        if (OAuthVersion.v10a.equals((Object)version)) {
            requestToken = service.getRequestToken();
            if (request != null) {
                request.getSession().setAttribute(REQUEST_TOKEN, (Object)requestToken);
            }
        } else {
            requestToken = null;
        }
        String authUrl = service.getAuthorizationUrl(requestToken);
        return authUrl;
    }

    @Override
    public String getAuthorizationUrl(OAuthVersion version) {
        return this.doGetAuthorizationUrl(version, null);
    }

    @Override
    public void oauthCallback(OAuthVersion version, HttpServletRequest request) {
        String oAuthVerifier;
        Token requestToken = null;
        if (OAuthVersion.v10a.equals((Object)version)) {
            oAuthVerifier = request.getParameter("oauth_verifier");
            requestToken = (Token)request.getSession().getAttribute(REQUEST_TOKEN);
        } else {
            oAuthVerifier = request.getParameter("code");
        }
        Verifier verifier = new Verifier(oAuthVerifier);
        String userId = request.getParameter("user_id");
        try {
            userId = URLDecoder.decode(userId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        OAuthService service = this.getService(version, OAuthProtocol.threelegged);
        Token accessToken = service.getAccessToken(requestToken, verifier);
        this.repository.storeToken(accessToken, userId, version);
    }

    @Override
    public Person getPerson(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parsePerson(in).getEntry();
    }

    @Override
    public List<Person> getGroupMembers(String groupId, String onBehalfOf) {
        if (!StringUtils.hasText((String)onBehalfOf)) {
            throw new IllegalArgumentException("For retrieving group members the onBehalfOf may not be empty");
        }
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + onBehalfOf + "/" + groupId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseTeamMembers(in).getEntry();
    }

    @Override
    public List<Group> getGroups(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups(in).getEntry();
    }

    @Override
    public List<Group20> getGroups20(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups20(in).getEntry();
    }

    private InputStream execute(String onBehalfOf, OAuthRequest request) {
        Token token;
        OAuthService service;
        if (onBehalfOf == null) {
            service = this.getService(OAuthVersion.v10a, OAuthProtocol.twolegged);
            token = new Token("", "");
        } else {
            OAuthToken oAuthToken = this.repository.getToken(onBehalfOf);
            if (oAuthToken == null) {
                throw new RuntimeException("No access token present for user('" + onBehalfOf + "'). First obtain an accesstoken.");
            }
            token = oAuthToken.getToken();
            service = this.getService(oAuthToken.getVersion(), OAuthProtocol.threelegged);
        }
        service.signRequest(token, request);
        Response oAuthResponse = request.send();
        if (oAuthResponse.getCode() >= 400) {
            throw new RuntimeException(String.format("Error response: %d, body: %s", oAuthResponse.getCode(), oAuthResponse.getStream() == null ? null : oAuthResponse.getBody()));
        }
        InputStream stream = oAuthResponse.getStream();
        if (LOG.isDebugEnabled()) {
            stream = this.logInputStream(stream);
        }
        return stream;
    }

    private InputStream logInputStream(InputStream stream) {
        String json;
        try {
            json = IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.debug(json);
        stream = IOUtils.toInputStream((String)json);
        return stream;
    }

    private OAuthService getService(OAuthVersion version, OAuthProtocol protocol) {
        String baseUrl = this.environment.getEndpointBaseUrl();
        OpenConextApi20AuthorizationCode api = version.equals((Object)OAuthVersion.v10a) ? (protocol.equals((Object)OAuthProtocol.twolegged) ? new OpenConextApi10aTwoLegged() : new OpenConextApi10aThreeLegged(baseUrl)) : new OpenConextApi20AuthorizationCode(baseUrl);
        OAuthService service = new ServiceBuilder().provider((Api)api).apiKey(this.environment.getOauthKey()).apiSecret(this.environment.getOauthSecret()).callback(this.environment.getCallbackUrl()).build();
        return service;
    }
}

