/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.surfnet.coin.api.client.InMemoryOAuthRepositoryImpl;
import nl.surfnet.coin.api.client.OAuthEnvironment;
import nl.surfnet.coin.api.client.OAuthRepository;
import nl.surfnet.coin.api.client.OAuthVersion;
import nl.surfnet.coin.api.client.OpenConextJsonParser;
import nl.surfnet.coin.api.client.OpenConextOAuthClient;
import nl.surfnet.coin.api.client.domain.Group;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.api.client.internal.OAuthProtocol;
import nl.surfnet.coin.api.client.internal.OAuthToken;
import nl.surfnet.coin.api.client.internal.OpenConextApi10aThreeLegged;
import nl.surfnet.coin.api.client.internal.OpenConextApi10aTwoLegged;
import nl.surfnet.coin.api.client.internal.OpenConextApi20AuthorizationCode;
import org.apache.commons.io.IOUtils;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OpenConextOAuthClientImpl
implements OpenConextOAuthClient,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConextOAuthClientImpl.class);
    private static final String REQUEST_TOKEN = "REQUEST_TOKEN";
    private OAuthEnvironment environment;
    private OAuthRepository repository;
    private OpenConextJsonParser parser = new OpenConextJsonParser();

    public OpenConextOAuthClientImpl() {
        this.environment = new OAuthEnvironment();
        this.environment.setVersion(OAuthVersion.v2);
        this.repository = new InMemoryOAuthRepositoryImpl();
    }

    @Override
    public boolean isAccessTokenGranted(String userId) {
        return this.repository.getToken(userId) != null;
    }

    private String doGetAuthorizationUrl(HttpServletRequest request) {
        Token requestToken;
        OAuthVersion version = this.environment.getVersion();
        OAuthService service = this.getService(version, OAuthProtocol.threelegged);
        if (OAuthVersion.v10a.equals((Object)version)) {
            requestToken = service.getRequestToken();
            if (request != null) {
                request.getSession().setAttribute(REQUEST_TOKEN, (Object)requestToken);
            }
        } else {
            requestToken = null;
        }
        return service.getAuthorizationUrl(requestToken);
    }

    @Override
    public String getAuthorizationUrl() {
        return this.doGetAuthorizationUrl(null);
    }

    @Override
    public void oauthCallback(HttpServletRequest request, String onBehalfOf) {
        String oAuthVerifier;
        Token requestToken = null;
        OAuthVersion version = this.environment.getVersion();
        if (OAuthVersion.v10a.equals((Object)version)) {
            oAuthVerifier = request.getParameter("oauth_verifier");
            requestToken = (Token)request.getSession().getAttribute(REQUEST_TOKEN);
        } else {
            oAuthVerifier = request.getParameter("code");
        }
        Verifier verifier = new Verifier(oAuthVerifier);
        OAuthService service = this.getService(version, OAuthProtocol.threelegged);
        Token accessToken = service.getAccessToken(requestToken, verifier);
        this.repository.storeToken(accessToken, onBehalfOf, version);
    }

    @Override
    public Person getPerson(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parsePerson(in).getEntry();
    }

    @Override
    public List<Person> getGroupMembers(String groupId, String onBehalfOf) {
        if (!StringUtils.hasText((String)onBehalfOf)) {
            throw new IllegalArgumentException("For retrieving group members the onBehalfOf may not be empty");
        }
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + onBehalfOf + "/" + groupId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseTeamMembers(in).getEntry();
    }

    @Override
    public List<Group> getGroups(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups(in).getEntry();
    }

    @Override
    public List<Group20> getGroups20(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups20(in).getEntry();
    }

    @Override
    public Group20 getGroup20(String userId, String groupId, String onBehalfOf) {
        String url = String.format("%ssocial/rest/groups/%s/%s", this.environment.getEndpointBaseUrl(), userId, groupId);
        OAuthRequest request = new OAuthRequest(Verb.GET, url);
        InputStream in = this.execute(onBehalfOf, request);
        List<Group20> entry = this.parser.parseGroups20(in).getEntry();
        if (entry != null && entry.size() > 0) {
            return entry.get(0);
        }
        return null;
    }

    private InputStream execute(String onBehalfOf, OAuthRequest request) {
        Response oAuthResponse;
        Token token;
        OAuthService service;
        if (onBehalfOf == null) {
            service = this.getService(OAuthVersion.v10a, OAuthProtocol.twolegged);
            token = new Token("", "");
        } else {
            OAuthToken oAuthToken = this.repository.getToken(onBehalfOf);
            if (oAuthToken == null) {
                throw new RuntimeException("No access token present for user('" + onBehalfOf + "'). First obtain an accesstoken.");
            }
            token = oAuthToken.getToken();
            service = this.getService(oAuthToken.getVersion(), OAuthProtocol.threelegged);
        }
        service.signRequest(token, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Will send request '{}'", (Object)request.toString());
        }
        if ((oAuthResponse = request.send()).getCode() >= 400) {
            throw new RuntimeException(String.format("Error response: %d, body: %s", oAuthResponse.getCode(), oAuthResponse.getStream() == null ? null : oAuthResponse.getBody()));
        }
        InputStream stream = oAuthResponse.getStream();
        if (LOG.isDebugEnabled()) {
            stream = this.logInputStream(stream);
        }
        return stream;
    }

    private InputStream logInputStream(InputStream stream) {
        String json;
        try {
            json = IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.debug(json);
        stream = IOUtils.toInputStream((String)json);
        return stream;
    }

    private OAuthService getService(OAuthVersion version, OAuthProtocol protocol) {
        String baseUrl = this.environment.getEndpointBaseUrl();
        OpenConextApi20AuthorizationCode api = version.equals((Object)OAuthVersion.v10a) ? (protocol.equals((Object)OAuthProtocol.twolegged) ? new OpenConextApi10aTwoLegged() : new OpenConextApi10aThreeLegged(baseUrl)) : new OpenConextApi20AuthorizationCode(baseUrl);
        return new ServiceBuilder().provider((Api)api).apiKey(this.environment.getOauthKey()).scope("read").apiSecret(this.environment.getOauthSecret()).callback(this.environment.getCallbackUrl()).build();
    }

    public void setCallbackUrl(String url) {
        this.environment.setCallbackUrl(url);
    }

    public void setConsumerSecret(String secret) {
        this.environment.setOauthSecret(secret);
    }

    public void setConsumerKey(String key) {
        this.environment.setOauthKey(key);
    }

    public void setEndpointBaseUrl(String url) {
        this.environment.setEndpointBaseUrl(url);
    }

    public void setVersion(OAuthVersion v) {
        this.environment.setVersion(v);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.environment);
        Assert.notNull((Object)this.environment.getEndpointBaseUrl(), (String)"endpoint base url cannot be null");
        Assert.notNull((Object)this.repository);
    }

    public void setRepository(OAuthRepository repository) {
        this.repository = repository;
    }
}

