/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import nl.surfnet.coin.api.client.domain.AbstractEntry;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupEntry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.api.client.domain.PersonEntry;
import nl.surfnet.coin.api.client.domain.ResultWrapper;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

public class OpenConextJsonParser {
    private ObjectMapper objectMapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);

    public GroupMembersEntry parseTeamMembers(InputStream in) {
        GroupMembersEntry result;
        block4: {
            try {
                String json = IOUtils.toString((InputStream)in);
                ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
                JsonNode jsonNodes = this.objectMapper.readTree(json);
                if (jsonNodes.has("result")) {
                    result = this.parseTeamMembersResultWrapper(stream).getResult();
                    break block4;
                }
                if (jsonNodes.has("entry")) {
                    result = (GroupMembersEntry)this.parse(stream, GroupMembersEntry.class);
                    break block4;
                }
                throw new RuntimeException("Unrecognized JSON " + json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public PersonEntry parsePerson(InputStream in) {
        return (PersonEntry)this.parse(in, PersonEntry.class);
    }

    public GroupEntry parseGroups(InputStream in) {
        return (GroupEntry)this.parse(in, GroupEntry.class);
    }

    public Group20Entry parseGroups20(InputStream in) {
        Group20Entry result;
        block4: {
            try {
                String json = IOUtils.toString((InputStream)in);
                ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
                JsonNode jsonNodes = this.objectMapper.readTree(json);
                if (jsonNodes.has("result")) {
                    result = this.parseGroup20ResultWrapper(stream).getResult();
                    break block4;
                }
                if (jsonNodes.has("entry")) {
                    result = (Group20Entry)this.parse(stream, Group20Entry.class);
                    break block4;
                }
                throw new RuntimeException("Unrecognized JSON " + json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private ResultWrapper<Group20Entry> parseGroup20ResultWrapper(InputStream in) {
        try {
            return (ResultWrapper)this.objectMapper.readValue(in, (TypeReference)new TypeReference<ResultWrapper<Group20Entry>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ResultWrapper<GroupMembersEntry> parseTeamMembersResultWrapper(InputStream in) {
        try {
            return (ResultWrapper)this.objectMapper.readValue(in, (TypeReference)new TypeReference<ResultWrapper<GroupMembersEntry>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object parse(InputStream in, Class<? extends AbstractEntry> entry) {
        try {
            return this.objectMapper.readValue(in, entry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

