/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.surfnet.coin.api.client.domain.AbstractEntry;
import nl.surfnet.coin.api.client.domain.Group;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class GroupEntry
extends AbstractEntry {
    private List<Group> entry;

    public GroupEntry() {
    }

    public GroupEntry(List<Group> groups) {
        this.entry = groups;
    }

    public GroupEntry(Group20Entry groups20) {
        ArrayList<Group> myEntry = new ArrayList<Group>();
        for (Group20 group20 : groups20.getEntry()) {
            myEntry.add(new Group(group20));
        }
        this.entry = myEntry;
        this.setFiltered(groups20.isFiltered());
        this.setItemsPerPage(groups20.getItemsPerPage());
        this.setSorted(groups20.isSorted());
        this.setStartIndex(groups20.getStartIndex());
        this.setTotalResults(groups20.getTotalResults());
        this.setUpdatedSince(groups20.getUpdatedSince());
    }

    public List<Group> getEntry() {
        return this.entry;
    }

    public void setEntry(List<Group> entry) {
        this.entry = entry;
    }

    @Override
    public int getEntrySize() {
        return this.entry != null ? this.entry.size() : 0;
    }

    @Override
    @JsonIgnore
    public List getEntryCollection() {
        return this.entry;
    }

    @Override
    @JsonIgnore
    public void sortEntryCollection(String sort) {
        if (StringUtils.isNotBlank((String)sort) && Group20Entry.SORT_ATR.contains(sort)) {
            BeanComparator beanComparator = new BeanComparator(sort, Group20Entry.NULL_SAFE_STRING_COMPARATOR);
            Collections.sort(this.entry, beanComparator);
        }
    }

    @Override
    @JsonIgnore
    public void setEntryCollection(List entry) {
        this.entry = entry;
    }
}

