/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.domain;

import nl.surfnet.coin.teams.domain.GroupProvider;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.springframework.util.StringUtils;

public class ThreeLeggedOauth10aGroupProviderApi
extends DefaultApi10a {
    private final GroupProvider groupProvider;

    public ThreeLeggedOauth10aGroupProviderApi(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    public Verb getAccessTokenVerb() {
        String method = this.groupProvider.getAllowedOptionAsString("auth.requestMethod");
        if (Verb.GET.toString().equalsIgnoreCase(method)) {
            return Verb.GET;
        }
        return Verb.POST;
    }

    public Verb getRequestTokenVerb() {
        return this.getAccessTokenVerb();
    }

    public String getRequestTokenEndpoint() {
        return this.groupProvider.getAllowedOptionAsString("auth.requestTokenUrl");
    }

    public String getAccessTokenEndpoint() {
        return this.groupProvider.getAllowedOptionAsString("auth.accessTokenUrl");
    }

    public String getAuthorizationUrl(Token requestToken) {
        String authBaseUrl = (String)this.groupProvider.getAllowedOptions().get("auth.authorizeUrl");
        if (StringUtils.hasText((String)authBaseUrl)) {
            return authBaseUrl + "?oauth_token=" + requestToken.getToken();
        }
        throw new IllegalArgumentException("Missing or incorrect Group Provider option auth.authorizeUrl");
    }
}

