/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.surfnet.coin.teams.domain.ConversionRule;
import nl.surfnet.coin.teams.domain.GroupProviderType;
import nl.surfnet.coin.teams.domain.ServiceProviderGroupAcl;
import nl.surfnet.coin.teams.util.PHPRegexConverter;
import org.springframework.util.StringUtils;

public class GroupProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String identifier;
    private String name;
    private String logoUrl;
    private GroupProviderType groupProviderType;
    private Map<String, Object> allowedOptions;
    private List<ConversionRule> groupDecorators = new ArrayList<ConversionRule>();
    private List<ConversionRule> groupFilters = new ArrayList<ConversionRule>();
    private List<ConversionRule> personDecorators = new ArrayList<ConversionRule>();
    private List<ConversionRule> personFilters = new ArrayList<ConversionRule>();
    private List<ServiceProviderGroupAcl> serviceProviderGroupAcls = new ArrayList<ServiceProviderGroupAcl>();
    private String userIdPrecondition;

    public GroupProvider() {
    }

    public GroupProvider(Long id, String identifier, String name, String groupProviderType) {
        this(id, identifier, name, GroupProviderType.fromString(groupProviderType));
    }

    public GroupProvider(Long id, String identifier, String name, GroupProviderType type) {
        this.id = id;
        this.identifier = identifier;
        this.name = name;
        this.groupProviderType = type;
        this.allowedOptions = new HashMap<String, Object>();
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public GroupProviderType getGroupProviderType() {
        return this.groupProviderType;
    }

    public Map<String, Object> getAllowedOptions() {
        return this.allowedOptions;
    }

    public void addAllowedOption(String key, Object value) {
        this.allowedOptions.put(key, value);
    }

    public void setAllowedOptions(Map<String, Object> allowedOptions) {
        this.allowedOptions = allowedOptions;
    }

    public String getAllowedOptionAsString(String key) {
        return (String)this.allowedOptions.get(key);
    }

    public String getUserIdPrecondition() {
        return this.userIdPrecondition;
    }

    public void setUserIdPrecondition(String userIdPrecondition) {
        this.userIdPrecondition = PHPRegexConverter.convertPHPRegexPattern(userIdPrecondition);
    }

    public List<ConversionRule> getGroupDecorators() {
        return this.groupDecorators;
    }

    public void setGroupDecorators(List<ConversionRule> groupDecorators) {
        this.groupDecorators = groupDecorators;
    }

    public void addGroupDecorator(ConversionRule groupIdDecorator) {
        this.groupDecorators.add(groupIdDecorator);
    }

    public List<ConversionRule> getGroupFilters() {
        return this.groupFilters;
    }

    public void setGroupFilters(List<ConversionRule> groupFilters) {
        this.groupFilters = groupFilters;
    }

    public void addGroupFilter(ConversionRule groupIdFilter) {
        this.groupFilters.add(groupIdFilter);
    }

    public List<ConversionRule> getPersonDecorators() {
        return this.personDecorators;
    }

    public void setPersonDecorators(List<ConversionRule> personDecorators) {
        this.personDecorators = personDecorators;
    }

    public void addPersonDecorator(ConversionRule personIdDecorator) {
        this.personDecorators.add(personIdDecorator);
    }

    public List<ConversionRule> getPersonFilters() {
        return this.personFilters;
    }

    public void setPersonFilters(List<ConversionRule> personFilters) {
        this.personFilters = personFilters;
    }

    public void addPersonFilter(ConversionRule personIdFilter) {
        this.personFilters.add(personIdFilter);
    }

    public boolean isMeantForUser(String userId) {
        return !StringUtils.hasText((String)this.userIdPrecondition) || userId.matches(this.userIdPrecondition);
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public boolean isExternalGroupProvider() {
        return !this.getGroupProviderType().equals(GroupProviderType.GROUPER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupProvider that = (GroupProvider)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GroupProvider");
        sb.append("{id=").append(this.id);
        sb.append(", identifier='").append(this.identifier).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", userIdPrecondition").append(this.userIdPrecondition).append('\'');
        sb.append(", groupProviderType=").append(this.groupProviderType);
        sb.append('}');
        return sb.toString();
    }

    public List<ServiceProviderGroupAcl> getServiceProviderGroupAcls() {
        return this.serviceProviderGroupAcls;
    }

    public void setServiceProviderGroupAcls(List<ServiceProviderGroupAcl> serviceProviderGroupAcls) {
        this.serviceProviderGroupAcls = serviceProviderGroupAcls;
    }

    public void addServiceProviderGroupAcl(ServiceProviderGroupAcl serviceProviderGroupAcl) {
        this.serviceProviderGroupAcls.add(serviceProviderGroupAcl);
    }
}

