/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import nl.surfnet.coin.api.client.OpenConextJsonParser;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.teams.domain.GroupProvider;
import nl.surfnet.coin.teams.util.GroupProviderPropertyConverter;
import org.springframework.util.StringUtils;

public abstract class AbstractGroupService {
    private static final OpenConextJsonParser parser = new OpenConextJsonParser();

    protected GroupMembersEntry getGroupMembersEntryFromResponse(InputStream in, GroupProvider provider) {
        GroupMembersEntry groupMembersEntry = parser.parseTeamMembers(in);
        List persons = groupMembersEntry.getEntry();
        Iterator iterator = persons.iterator();
        while (iterator.hasNext()) {
            Person person = (Person)iterator.next();
            String id = person.getId();
            if (StringUtils.hasText((String)id)) {
                String collabId = GroupProviderPropertyConverter.convertToSurfConextPersonId(id, provider);
                person.setId(collabId);
                continue;
            }
            iterator.remove();
        }
        return groupMembersEntry;
    }

    protected Group20Entry getGroup20EntryFromResponse(InputStream in, GroupProvider groupProvider) {
        Group20Entry entry = parser.parseGroups20(in);
        for (Group20 group20 : entry.getEntry()) {
            String scGroupId = GroupProviderPropertyConverter.convertToSurfConextGroupId(group20.getId(), groupProvider);
            group20.setId(scGroupId);
            String scGroupName = GroupProviderPropertyConverter.convertProperty("name", group20.getTitle(), groupProvider.getGroupFilters());
            group20.setTitle(scGroupName);
            String scGroupDesc = GroupProviderPropertyConverter.convertProperty("description", group20.getDescription(), groupProvider.getGroupFilters());
            group20.setDescription(scGroupDesc);
        }
        return entry;
    }
}

