/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.teams.domain.GroupProvider;
import nl.surfnet.coin.teams.service.BasicAuthGroupService;
import nl.surfnet.coin.teams.service.impl.AbstractGroupService;
import nl.surfnet.coin.teams.util.GroupProviderPropertyConverter;
import org.springframework.stereotype.Component;

@Component(value="basicAuthGroupService")
public class GroupServiceBasicAuthentication
extends AbstractGroupService
implements BasicAuthGroupService {
    private Client client = Client.create();

    @Override
    public Group20Entry getGroup20Entry(GroupProvider groupProvider, String personId, int limit, int offset) {
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        Client client = this.getClient(groupProvider);
        String url = String.format("%s/groups/%s?startIndex=%s&count=%s", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, offset, limit);
        WebResource webResource = client.resource(url);
        InputStream response = (InputStream)webResource.get(InputStream.class);
        Group20Entry entry = this.getGroup20EntryFromResponse(response, groupProvider);
        return entry;
    }

    @Override
    public Group20 getGroup20(GroupProvider groupProvider, String personId, String groupId) {
        String url;
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        String strippedGroupID = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider);
        Client client = this.getClient(groupProvider);
        WebResource webResource = client.resource(url = String.format("%s/groups/%s/%s", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupID));
        InputStream response = (InputStream)webResource.get(InputStream.class);
        Group20Entry entry = this.getGroup20EntryFromResponse(response, groupProvider);
        if (entry == null) {
            return null;
        }
        List group20s = entry.getEntry();
        if (group20s != null && group20s.size() == 1) {
            return (Group20)group20s.get(0);
        }
        throw new RuntimeException(String.format("Received %s groups for groupid %s", group20s.size(), groupId));
    }

    @Override
    public GroupMembersEntry getGroupMembersEntry(GroupProvider groupProvider, String personId, String groupId, int limit, int offset) {
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        String strippedGroupId = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider);
        Client client = this.getClient(groupProvider);
        String url = String.format("%s/people/%s/%s?startIndex=%s&count=%s&sortBy=name.familyName", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupId, offset, limit);
        WebResource webResource = client.resource(url);
        String response = (String)webResource.get(String.class);
        ByteArrayInputStream in = new ByteArrayInputStream(response.getBytes());
        GroupMembersEntry entry = this.getGroupMembersEntryFromResponse(in, groupProvider);
        return entry;
    }

    private Client getClient(GroupProvider groupProvider) {
        String user = groupProvider.getAllowedOptionAsString("user");
        String password = groupProvider.getAllowedOptionAsString("password");
        this.client.removeAllFilters();
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
        return this.client;
    }
}

