/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.teams.service.impl.AbstractGrouperDaoImpl;
import nl.surfnet.coin.teams.service.impl.ApiGrouperDao;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;

public class ApiGrouperDaoImpl
extends AbstractGrouperDaoImpl
implements ApiGrouperDao {
    private static final Logger LOG = LoggerFactory.getLogger(ApiGrouperDaoImpl.class);
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private static final Map<String, String> VALID_SORTS_FOR_TEAM_QUERY = new HashMap<String, String>();

    @Override
    public Group20Entry findGroup20(String personId, String groupName) {
        Group20Entry group20Entry;
        Assert.notNull((Object)personId, (String)"The personId can not be null");
        Assert.notNull((Object)groupName, (String)"The groupName can not be null");
        try {
            LOG.debug("Query to grouper database for person '{}' in group '{}'", (Object)personId, (Object)groupName.toUpperCase());
            group20Entry = new Group20Entry(Arrays.asList((Group20)this.jdbcTemplate.queryForObject(SQL_FIND_TEAM_BY_MEMBER_AND_BY_GROUPNAME, new Object[]{personId, groupName.toUpperCase()}, (RowMapper)new OpenSocial20GroupRowMapper())));
            this.addRolesToGroups(personId, group20Entry.getEntry());
        }
        catch (EmptyResultDataAccessException ignored) {
            group20Entry = new Group20Entry();
        }
        return group20Entry;
    }

    @Override
    public Group20Entry findAllGroup20sByMember(String personId, Integer offset, Integer pageSize, String sortBy) {
        int rowCount = this.jdbcTemplate.queryForInt(SQL_FIND_ALL_TEAMS_BY_MEMBER_ROWCOUNT, new Object[]{personId});
        ArrayList<Group20> groups = new ArrayList();
        pageSize = this.correctPageSize(pageSize);
        offset = this.correctOffset(offset);
        try {
            String sql = this.formatAllTeamsSQLWithSortByOption(sortBy);
            groups = this.jdbcTemplate.query(sql, new Object[]{personId, pageSize, offset}, (RowMapper)new OpenSocial20GroupRowMapper());
            this.addRolesToGroups(personId, groups);
        }
        catch (EmptyResultDataAccessException e) {
            // empty catch block
        }
        return new Group20Entry(groups, pageSize.intValue(), offset.intValue(), sortBy, rowCount);
    }

    protected String formatAllTeamsSQLWithSortByOption(String sortBy) {
        String sql = SQL_FIND_ALL_TEAMS_BY_MEMBER_SORTED;
        if (!StringUtils.isBlank((String)sortBy)) {
            String sortByColumn = null;
            Set<Map.Entry<String, String>> entrySet = VALID_SORTS_FOR_TEAM_QUERY.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (!entry.getKey().equals(sortBy)) continue;
                sortByColumn = entry.getValue();
                break;
            }
            Assert.isTrue((!StringUtils.isBlank(sortByColumn) ? 1 : 0) != 0, (String)("The only supported sortBy options are (" + VALID_SORTS_FOR_TEAM_QUERY.keySet() + "). Not allowed is '" + sortBy + "'"));
            sql = String.format(sql, sortByColumn);
        } else {
            sql = String.format(sql, "name");
        }
        return sql;
    }

    private void addRolesToGroups(String personId, List<Group20> groups) {
        try {
            RolesRowCallbackHandler handler = new RolesRowCallbackHandler();
            this.jdbcTemplate.query(" select gf.name as fieldname, gg.name as groupname from grouper_memberships gms, grouper_groups gg, grouper_fields gf,  grouper_stems gs, grouper_members gm where  gms.field_id = gf.id and  gms.owner_group_id = gg.id and  gms.member_id = gm.id  and gm.subject_id = ?   and gg.parent_stem = gs.id  and gs.name != 'etc'  and (gf.name = 'admins' or gf.name = 'updaters') order by gg.name ", new Object[]{personId}, (RowCallbackHandler)handler);
            Map<String, Role> roles = handler.roles;
            for (Group20 group : groups) {
                Role role = roles.get(group.getId());
                role = role == null ? Role.Member : role;
                group.setVoot_membership_role(role.name().toLowerCase());
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public GroupMembersEntry findAllMembers(String groupId, Integer offset, Integer pageSize) {
        ArrayList<Person> persons = new ArrayList();
        pageSize = this.correctPageSize(pageSize);
        offset = this.correctOffset(offset);
        try {
            RowMapper<Person> mapper = new RowMapper<Person>(){

                public Person mapRow(ResultSet rs, int rowNum) throws SQLException {
                    Person person = new Person();
                    person.setId(rs.getString(1));
                    return person;
                }
            };
            persons = this.jdbcTemplate.query(" select distinct gm.subject_id as subject_id from grouper_memberships gms, grouper_groups gg, grouper_stems gs, grouper_members gm where gms.owner_group_id = gg.id and gms.member_id = gm.id and gg.parent_stem = gs.id and gs.name != 'etc' and gm.subject_id != 'GrouperSystem' and gm.subject_id != 'GrouperAll' and gg.name = ? order by gm.subject_id limit ? offset ?", new Object[]{groupId, pageSize, offset}, (RowMapper)mapper);
            if (CollectionUtils.isNotEmpty(persons)) {
                this.addPersonRolesToGroup(persons, groupId);
            }
        }
        catch (EmptyResultDataAccessException e) {
            // empty catch block
        }
        return new GroupMembersEntry(persons);
    }

    @Override
    public Group20Entry findGroups20ByIds(String personId, String[] groupIds, Integer pageSize, Integer offset) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupId", Arrays.asList(groupIds));
        List<Group20> groups = new ArrayList();
        pageSize = this.correctPageSize(pageSize);
        offset = this.correctOffset(offset);
        params.put("limit", pageSize);
        params.put("offset", offset);
        try {
            String sql = SQL_FIND_TEAMS_BY_GROUPIDS;
            groups = this.namedParameterJdbcTemplate.query(sql, params, (RowMapper)new OpenSocial20GroupRowMapper());
            this.addRolesToGroups(personId, groups);
        }
        catch (EmptyResultDataAccessException e) {
            // empty catch block
        }
        return new Group20Entry(groups, pageSize.intValue(), offset.intValue(), null, groups.size());
    }

    private void addPersonRolesToGroup(Collection<Person> persons, String groupId) {
        try {
            RolesMembersRowCallbackHandler handler = new RolesMembersRowCallbackHandler();
            Collection personIds = CollectionUtils.collect(persons, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Person)input).getId();
                }
            });
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("groupId", groupId);
            params.put("identifiers", personIds);
            this.namedParameterJdbcTemplate.query("select gm.subject_id as subject_id, gf.name as fieldname, gg.name as groupname from grouper_memberships gms, grouper_groups gg, grouper_fields gf, grouper_stems gs, grouper_members gm where gms.field_id = gf.id and  gms.owner_group_id = gg.id and gms.member_id = gm.id and gg.parent_stem = gs.id and gs.name != 'etc' and subject_id in (:identifiers) and (gf.name = 'admins' or gf.name = 'updaters') and gg.name = :groupId", params, (RowCallbackHandler)handler);
            for (Person person : persons) {
                Role role = (Role)((Object)handler.roles.get(person.getId()));
                role = role == null ? Role.Member : role;
                person.setVoot_membership_role(role.name().toLowerCase());
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    static {
        VALID_SORTS_FOR_TEAM_QUERY.put("id", "name");
        VALID_SORTS_FOR_TEAM_QUERY.put("title", "display_name");
        VALID_SORTS_FOR_TEAM_QUERY.put("description", "description");
    }

    private class RolesMembersRowCallbackHandler
    extends RolesRowCallbackHandler {
        private RolesMembersRowCallbackHandler() {
        }

        @Override
        public void processRow(ResultSet rs) throws SQLException {
            String personName = rs.getString("subject_id");
            String permission = rs.getString("fieldname");
            Role role = (Role)((Object)this.roles.get(personName));
            if (!Role.Admin.equals((Object)role)) {
                this.roles.put(personName, permission.equals("admins") ? Role.Admin : Role.Manager);
            }
        }
    }

    private class RolesRowCallbackHandler
    implements RowCallbackHandler {
        protected Map<String, Role> roles = new HashMap<String, Role>();

        public void processRow(ResultSet rs) throws SQLException {
            String groupName = rs.getString("groupname");
            String permission = rs.getString("fieldname");
            Role role = this.roles.get(groupName);
            if (!Role.Admin.equals((Object)role)) {
                this.roles.put(groupName, permission.equals("admins") ? Role.Admin : Role.Manager);
            }
        }
    }

    private static enum Role {
        Manager,
        Admin,
        Member,
        none;

    }

    public static class OpenSocial20GroupRowMapper
    extends AbstractGrouperDaoImpl.GrouperRowMapper<Group20> {
        @Override
        public Group20 createObj(String id, String name, String description) {
            return new Group20(id, name, description);
        }
    }
}

